/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageToolbar;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Language;

public class LanguageToolbar
extends AbstractLanguageToolbar<EditorBox> {
    private Language language;
    private LanguageTab tab;

    public LanguageToolbar(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void tab(LanguageTab tab) {
        this.tab = tab;
    }

    public void refresh() {
        super.refresh();
        this.refreshAbout();
        this.refreshExamples();
        this.refreshHelp();
        this.refreshLogo();
    }

    private void refreshAbout() {
        this.aboutText.visible(this.tab == LanguageTab.About);
        this.aboutLink.visible(this.tab != LanguageTab.About);
        if (this.aboutText.isVisible()) {
            this.aboutText.value(this.translate("about"));
        }
        if (this.aboutLink.isVisible()) {
            this.aboutLink.address(a -> PathHelper.languagePath(a, this.language, LanguageTab.About));
            this.aboutLink.title(this.translate("about"));
        }
    }

    private void refreshHelp() {
        this.helpText.visible(this.tab == LanguageTab.Help);
        this.helpLink.visible(this.tab != LanguageTab.Help);
        if (this.helpLink.isVisible()) {
            this.helpLink.address(a -> PathHelper.languagePath(a, this.language, LanguageTab.Help));
        }
    }

    private void refreshExamples() {
        boolean hasExamples = LanguageHelper.hasExamples(this.language);
        this.examplesText.visible(hasExamples && this.tab == LanguageTab.Examples);
        this.examplesLink.visible(hasExamples && this.tab != LanguageTab.Examples);
        if (this.examplesLink.isVisible()) {
            this.examplesLink.address(a -> PathHelper.languagePath(a, this.language, LanguageTab.Examples));
        }
    }

    private void refreshLogo() {
        this.languageLogo.value(LanguageHelper.logo(this.language, (EditorBox)this.box()));
    }
}

