/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.models;

import io.intino.alexandria.Json;
import io.intino.alexandria.logger.Logger;
import io.intino.ls.IntinoLanguageServer;
import io.intino.ls.codeinsight.DiagnosticService;
import io.quassar.archetype.Archetype;
import io.quassar.editor.box.languages.LanguageServerManager;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.models.ModelContainer;
import io.quassar.editor.box.models.Workspace;
import io.quassar.editor.box.models.WorkspaceReader;
import io.quassar.editor.box.models.WorkspaceWriter;
import io.quassar.editor.box.util.ArchetypeHelper;
import io.quassar.editor.box.util.SubjectHelper;
import io.quassar.editor.box.util.VersionNumberComparator;
import io.quassar.editor.box.util.ZipHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Manifest;
import io.quassar.editor.model.Model;
import io.quassar.editor.model.ModelRelease;
import io.quassar.editor.model.OperationResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.tika.Tika;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.services.LanguageServer;
import systems.intino.datamarts.subjectstore.SubjectQuery;
import systems.intino.datamarts.subjectstore.SubjectStore;
import systems.intino.datamarts.subjectstore.model.Subject;

public class ModelManager {
    private final SubjectStore subjectStore;
    private final Archetype archetype;
    private final Function<GavCoordinates, Language> languageLoader;
    private final LanguageServerManager serverManager;
    private static final List<String> TextContentTypes = List.of("text/", "application/json", "application/xml", "application/javascript", "application/xhtml+xml");

    public ModelManager(Archetype archetype, SubjectStore store, Function<GavCoordinates, Language> languageLoader, LanguageServerManager serverManager) {
        this.subjectStore = store;
        this.archetype = archetype;
        this.languageLoader = languageLoader;
        this.serverManager = serverManager;
    }

    public List<Model> models(Language language, String owner) {
        Map<String, Subject> ownerSubjects = this.mapOf(this.with(this.subjectStore.query().isType("model"), "dsl-collection", language.collection()).where("dsl-name").equals(language.name()).where("owner").equals(owner).where("usage").equals(Model.Usage.EndUser.name()).collect());
        Map<String, Subject> contributorSubjects = this.mapOf(this.with(this.subjectStore.query().isType("model"), "dsl-collection", language.collection()).where("dsl-name").equals(language.name()).where("collaborator").equals(owner).where("usage").equals(Model.Usage.EndUser.name()).collect());
        ownerSubjects.putAll(contributorSubjects);
        return ownerSubjects.values().stream().map(this::get).toList();
    }

    public List<Model> models(Language language) {
        Map<String, Subject> ownerSubjects = this.mapOf(this.with(this.subjectStore.query().isType("model"), "dsl-collection", language.collection()).where("dsl-name").equals(language.name()).collect());
        Map<String, Subject> contributorSubjects = this.mapOf(this.with(this.subjectStore.query().isType("model"), "dsl-collection", language.collection()).where("dsl-name").equals(language.name()).collect());
        ownerSubjects.putAll(contributorSubjects);
        return ownerSubjects.values().stream().map(this::get).toList();
    }

    public List<Model> models(String owner) {
        Map<String, Subject> ownerSubjects = this.mapOf(this.subjectStore.query().isType("model").where("owner").equals(owner).where("usage").equals(Model.Usage.EndUser.name()).collect());
        Map<String, Subject> contributorSubjects = this.mapOf(this.subjectStore.query().isType("model").where("collaborator").equals(owner).where("usage").equals(Model.Usage.EndUser.name()).collect());
        ownerSubjects.putAll(contributorSubjects);
        return ownerSubjects.values().stream().map(this::get).toList();
    }

    public List<Model> exampleModels(Language language, LanguageRelease release) {
        if (release != null) {
            return release.examples().stream().map(this::get).toList();
        }
        return language.releases().stream().map(LanguageRelease::examples).flatMap(Collection::stream).distinct().map(this::get).toList();
    }

    public List<Model> models(String project, String module, String owner) {
        List result = this.subjectStore.query().isType("model").where("owner").equals(owner).where("project").equals(project).where("module").equals(module).collect();
        return result.stream().map(this::get).toList();
    }

    public List<String> projects(String owner) {
        List result = this.subjectStore.query().isType("model").where("owner").equals(owner).collect();
        return result.stream().map(s -> s.get("project")).filter(r -> r != null && !r.isEmpty()).distinct().toList();
    }

    public List<String> modules(String project, String owner) {
        if (project == null) {
            return Collections.emptyList();
        }
        List result = this.subjectStore.query().isType("model").where("owner").equals(owner).where("project").equals(project).collect();
        return result.stream().map(s -> s.get("module")).filter(r -> r != null && !r.isEmpty()).distinct().toList();
    }

    public boolean exists(String key) {
        return this.get(key) != null;
    }

    public Model find(String commit) {
        Subject subject = this.subjectStore.query().isType("release").where("commit").equals(commit).collect().stream().findFirst().orElse(null);
        if (subject == null || subject.isNull()) {
            return null;
        }
        return this.get(subject.parent());
    }

    public Model get(String key) {
        if (key == null) {
            return null;
        }
        Subject subject = this.subjectStore.open(SubjectHelper.modelPath(key));
        if (subject == null || subject.isNull()) {
            subject = this.subjectStore.query().isType("model").where("name").equals(key).collect().stream().findFirst().orElse(null);
        }
        return this.get(subject);
    }

    public Model getTemplate(Language language, LanguageRelease release) {
        return this.get((Subject)this.subjectStore.query().isType("model").where("usage").equals(Model.Usage.Template.name()).where("dsl-collection").equals(language.collection()).where("dsl-name").equals(language.name()).where("dsl-version").equals(release.version()).collect().stream().findFirst().orElse(null));
    }

    public List<String> releases(Model model) {
        List releases = this.archetype.models().releases(ArchetypeHelper.relativeModelPath(model.id()), model.id());
        return releases.stream().map(f -> f.getName().replace(".zip", "")).sorted((o1, o2) -> VersionNumberComparator.getInstance().compare((String)o1, (String)o2)).toList();
    }

    public java.io.File release(Model model, String version) {
        return this.archetype.models().release(ArchetypeHelper.relativeModelPath(model.id()), model.id(), version);
    }

    public ModelRelease findRelease(String commit) {
        return this.releaseOf(this.subjectStore.query().isType("release").where("commit").equals(commit).collect().stream().findFirst().orElse(null));
    }

    public Model create(String id, String name, String title, String description, GavCoordinates language, Model.Usage usage, String owner) {
        Model model = new Model(this.subjectStore.create(SubjectHelper.modelPath(id)));
        model.name(name);
        model.title(title.toUpperCase());
        model.description(description);
        model.language(language);
        model.owner(owner);
        model.isPrivate(true);
        model.usage(usage);
        model.createDate(Instant.now());
        model.updateDate(Instant.now());
        return model;
    }

    public Model clone(Model model, String release, String id, String name, String owner) {
        Model result = new Model(this.subjectStore.create(SubjectHelper.modelPath(id)));
        result.name(name);
        result.language(model.language());
        result.owner(owner);
        result.isPrivate(true);
        result.usage(Model.Usage.EndUser);
        result.createDate(Instant.now());
        model.updateDate(Instant.now());
        new WorkspaceWriter(this.workspace(model, release), (LanguageServer)this.server(model, release)).clone(result, (LanguageServer)this.server(result, "draft"));
        return this.get(id);
    }

    public List<Diagnostic> check(Model model, String release) {
        IntinoLanguageServer server = this.server(model, release);
        if (server == null) {
            return Collections.emptyList();
        }
        DiagnosticService diagnosticService = server.getDiagnosticService();
        if (diagnosticService == null) {
            return Collections.emptyList();
        }
        return diagnosticService.analyzeWorkspace();
    }

    public void updateLanguageVersion(Model model, String version) {
        GavCoordinates language = model.language();
        model.language(new GavCoordinates(language.groupId(), language.artifactId(), version));
        this.serverManager.remove(model, "draft");
    }

    public void removeLanguageServer(Model model) {
        this.serverManager.remove(model, "draft");
    }

    public void copyWorkSpace(Model template, Model model) {
        new WorkspaceWriter(this.workspace(template, "draft"), (LanguageServer)this.server(template, "draft")).clone(model, (LanguageServer)this.server(model, "draft"));
    }

    public boolean isWorkspaceEmpty(Model model, String release) {
        java.io.File workspace = this.workspace(model, release).root();
        java.io.File[] files = workspace.exists() ? workspace.listFiles() : null;
        return files == null || files.length == 0;
    }

    public boolean hasWorkspaceMograms(Model model, String release) {
        IntinoLanguageServer server = this.server(model, release);
        if (server == null) {
            return false;
        }
        DiagnosticService.Statistics statistics = server.getDiagnosticService().statistics();
        return statistics.mogramsPerUnit().values().stream().mapToLong(v -> v.intValue()).sum() > 0L;
    }

    public Workspace workspace(Model model, String release) {
        return new Workspace(model, release, this.languageLoader.apply(model.language()), this.archetype);
    }

    public File copy(Model model, String filename, File source) {
        return new WorkspaceWriter(this.workspace(model, "draft"), (LanguageServer)this.server(model, "draft")).copy(filename, source);
    }

    public OperationResult createRelease(Model model, String release) {
        try {
            if (this.isWorkspaceEmpty(model, "draft")) {
                return OperationResult.Error("Workspace is empty");
            }
            java.io.File releaseFile = this.archetype.models().release(ArchetypeHelper.relativeModelPath(model.id()), model.id(), release);
            ModelRelease modelRelease = new ModelRelease(this.subjectStore.create(SubjectHelper.pathOf(model, release)));
            modelRelease.commit(UUID.randomUUID().toString());
            modelRelease.version(release);
            modelRelease.language(model.language());
            modelRelease.owner(model.owner());
            ZipHelper.zip(this.workspace(model, "draft").root().toPath(), this.manifest(model, modelRelease), releaseFile.toPath());
            return OperationResult.Success();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return OperationResult.Error(e.getMessage());
        }
    }

    public OperationResult replaceRelease(Model model, String release) {
        try {
            if (this.isWorkspaceEmpty(model, "draft")) {
                return OperationResult.Error("Workspace is empty");
            }
            java.io.File releaseFile = this.archetype.models().release(ArchetypeHelper.relativeModelPath(model.id()), model.id(), release);
            ModelRelease modelRelease = model.release(release);
            ZipHelper.zip(this.workspace(model, "draft").root().toPath(), this.manifest(model, modelRelease), releaseFile.toPath());
            return OperationResult.Success();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return OperationResult.Error(e.getMessage());
        }
    }

    public void renameRelease(Model model, ModelRelease release, String newVersion) {
        ModelRelease newRelease = new ModelRelease(this.subjectStore.open(SubjectHelper.pathOf(model, release.version())).rename(newVersion));
        newRelease.version(newVersion);
    }

    public OperationResult removeRelease(Model model, String release) {
        try {
            java.io.File releaseFile;
            Subject subject = this.subjectStore.open(SubjectHelper.pathOf(model, release));
            if (subject != null) {
                subject.drop();
            }
            if ((releaseFile = this.archetype.models().release(ArchetypeHelper.relativeModelPath(model.id()), model.id(), release)).exists()) {
                releaseFile.delete();
            }
            return OperationResult.Success();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return OperationResult.Error(e.getMessage());
        }
    }

    private String manifest(Model model, ModelRelease modelRelease) {
        Manifest manifest = new Manifest();
        manifest.id(model.id());
        manifest.name(model.isTitleQualified() ? model.qualifiedTitle() : model.title());
        manifest.commit(modelRelease.commit());
        manifest.version(modelRelease.version());
        manifest.dsl(model.language().toString());
        manifest.owner(model.owner());
        return Json.toString((Object)manifest);
    }

    public boolean existsFile(Model model, String name, File parent) {
        return new WorkspaceReader(this.workspace(model, "draft"), (LanguageServer)this.server(model, "draft")).existsFile(name, parent);
    }

    public File createFile(Model model, String name, InputStream content, File parent) {
        model.updateDate(Instant.now());
        return new WorkspaceWriter(this.workspace(model, "draft"), (LanguageServer)this.server(model, "draft")).createFile(name, content, parent);
    }

    public File createFolder(Model model, String name, File parent) {
        model.updateDate(Instant.now());
        return new WorkspaceWriter(this.workspace(model, "draft"), (LanguageServer)this.server(model, "draft")).createFolder(name, parent);
    }

    public void save(Model model, File file, InputStream content) {
        model.updateDate(Instant.now());
        new WorkspaceWriter(this.workspace(model, "draft"), (LanguageServer)this.server(model, "draft")).save(file, content);
    }

    public File rename(Model model, File file, String newName) {
        model.updateDate(Instant.now());
        return new WorkspaceWriter(this.workspace(model, "draft"), (LanguageServer)this.server(model, "draft")).rename(file, newName);
    }

    public File move(Model model, File file, File directory) {
        try {
            model.updateDate(Instant.now());
            return new WorkspaceWriter(this.workspace(model, "draft"), (LanguageServer)this.server(model, "draft")).move(file, directory);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public void remove(Model model, File file) {
        model.updateDate(Instant.now());
        new WorkspaceWriter(this.workspace(model, "draft"), (LanguageServer)this.server(model, "draft")).remove(file);
    }

    public void remove(String model) {
        this.remove(this.get(model));
    }

    public void remove(Model model) {
        try {
            this.releases(model).forEach(r -> this.subjectStore.open(SubjectHelper.pathOf(model, r)).drop());
            this.subjectStore.open(SubjectHelper.pathOf(model)).drop();
            java.io.File rootDir = this.archetype.models().get(ArchetypeHelper.relativePath(model), model.id());
            if (!rootDir.exists()) {
                return;
            }
            FileUtils.deleteDirectory((java.io.File)rootDir);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public ModelContainer modelContainer(Model model, String release) {
        IntinoLanguageServer server = this.server(model, release);
        if (server == null) {
            return null;
        }
        return new ModelContainer(this.workspace(model, release), (LanguageServer)server);
    }

    public InputStream content(Model model, String release, String uri) {
        return new WorkspaceReader(this.workspace(model, release), (LanguageServer)this.server(model, release)).content(uri);
    }

    public List<Model> modelsWithRelease(Language language, String release) {
        if (language == null || release == null) {
            return Collections.emptyList();
        }
        List subjects = this.subjectStore.query().isType("model").where("dsl-collection").equals(language.collection()).where("dsl-name").equals(language.name()).where("dsl-version").equals(release).collect();
        return subjects.stream().map(this::get).filter(Objects::nonNull).toList();
    }

    public boolean existsModelsWithReleasesFor(Language language, String release) {
        if (language == null || release == null) {
            return false;
        }
        List<Model> models = this.modelsWithRelease(language, release).stream().filter(m -> m.usage() == Model.Usage.EndUser).toList();
        if (models.isEmpty()) {
            return false;
        }
        return models.stream().noneMatch(m -> m.releases().size() <= 1);
    }

    private IntinoLanguageServer server(Model model, String release) {
        try {
            return (IntinoLanguageServer)this.serverManager.get(model, release);
        }
        catch (IOException | URISyntaxException | GitAPIException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public boolean isTextFile(Model model, String release, File file) {
        if (!file.isResource()) {
            return true;
        }
        return this.isText(new java.io.File(this.workspace(model, release).root(), file.uri()));
    }

    private boolean isText(java.io.File file) {
        try {
            if (file.length() == 0L) {
                return true;
            }
            Tika tika = new Tika();
            String contentType = tika.detect(file);
            return TextContentTypes.stream().anyMatch(contentType::startsWith);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private Map<String, Subject> mapOf(List<Subject> subjects) {
        return subjects.stream().collect(Collectors.toMap(Subject::identifier, s -> s));
    }

    private Model get(Subject subject) {
        return subject != null && !subject.isNull() ? new Model(subject) : null;
    }

    private ModelRelease releaseOf(Subject subject) {
        return subject != null && !subject.isNull() ? new ModelRelease(subject) : null;
    }

    private SubjectQuery with(SubjectQuery query, String name, String value) {
        if (value.isEmpty()) {
            return query;
        }
        return query.where(name).equals(value);
    }
}

