/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.components.Grid;
import io.intino.alexandria.ui.displays.events.collection.CellClickEvent;
import io.intino.alexandria.ui.displays.events.collection.SortColumnEvent;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.alexandria.ui.model.datasource.grid.GridColumn;
import io.intino.alexandria.ui.model.datasource.grid.GridItem;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.CollectionCommands;
import io.quassar.editor.box.ui.datasources.LicensesDatasource;
import io.quassar.editor.box.ui.displays.templates.AbstractLicensesTemplate;
import io.quassar.editor.box.util.Formatters;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.box.util.UserHelper;
import io.quassar.editor.model.Collection;
import io.quassar.editor.model.License;
import java.util.Collections;
import java.util.List;

public class LicensesTemplate
extends AbstractLicensesTemplate<EditorBox> {
    private Collection collection;

    public LicensesTemplate(EditorBox box) {
        super(box);
    }

    public void collection(Collection collection) {
        this.collection = collection;
    }

    @Override
    public void init() {
        super.init();
        this.licensesGrid.onClickCell(this::copyLicenseToClipboard);
        this.licensesGrid.itemResolver(this.itemResolver());
        this.licensesGrid.onSortColumn(this::sort);
        this.licensesGrid.column("duration").formatter(value -> String.valueOf(value.asNumber().intValue()));
        this.addLicensesDialog.onOpen(e -> this.refreshLicensesDialog());
        this.addLicenses.onExecute(e -> this.addLicenses());
        this.countField.onChange(e -> this.addLicenses.readonly(!this.hasCredit()));
        this.durationField.onChange(e -> this.addLicenses.readonly(!this.hasCredit()));
    }

    public void refresh() {
        super.refresh();
        this.licensesGrid.source((Datasource)new LicensesDatasource((EditorBox)this.box(), this.session(), this.collection));
        this.addLicensesTrigger.visible(PermissionsHelper.canAddLicenses(this.collection, this.session(), (EditorBox)this.box()));
        this.addLicensesTrigger.readonly(!this.hasCredit());
    }

    private Grid.ItemResolver<License> itemResolver() {
        return new Grid.ItemResolver<License>(){

            public GridItem build(License license) {
                GridItem result = new GridItem();
                result.add((Object)license.code());
                result.add((Object)license.createDate());
                result.add((Object)license.duration());
                result.add((Object)LicensesTemplate.this.translate(license.status().name()));
                result.add((Object)license.user());
                result.add((Object)license.assignDate());
                result.add((Object)license.expireDate());
                return result;
            }

            public String address(GridColumn<License> column, License license) {
                return "";
            }
        };
    }

    private void refreshLicensesDialog() {
        int licenseTime = UserHelper.licenseTime(this.session(), (EditorBox)this.box());
        String licenseTimeFormatted = Formatters.formattedNumber((long)licenseTime, this.language());
        this.message.value(this.translate("You have %s months of license time available").formatted(licenseTimeFormatted));
        this.hint.value(this.translate("This can be used as one %s-month license or split into multiple shorter licenses (e.g., %s one-month licenses).").formatted(licenseTimeFormatted, licenseTimeFormatted));
    }

    private void addLicenses() {
        if (this.countField.value() == null || this.countField.value() <= 0.0) {
            this.notifyUser(this.translate("The number of licenses must be greater than zero"), UserMessage.Type.Error);
            return;
        }
        if (this.durationField.value() == null || this.durationField.value() <= 0.0) {
            this.notifyUser(this.translate("The duration in months for each license must be greater than zero"), UserMessage.Type.Error);
            return;
        }
        if (!this.hasCredit()) {
            this.notifyUser(this.translate("You don\u2019t have enough monthly credit to add these licenses"), UserMessage.Type.Error);
            return;
        }
        this.addLicensesDialog.close();
        ((EditorBox)this.box()).commands(CollectionCommands.class).addLicenses(this.collection, this.countField.value(), this.durationField.value(), this.username());
        this.refresh();
    }

    private boolean hasCredit() {
        return PermissionsHelper.hasCredit(Double.valueOf(this.countField.value() * this.durationField.value()).intValue(), this.session(), (EditorBox)this.box());
    }

    private void copyLicenseToClipboard(CellClickEvent event) {
        License license = (License)event.item();
        this.copyTrigger.text(license.code());
        this.copyTrigger.launch();
    }

    private void sort(SortColumnEvent event) {
        GridColumn column = event.column();
        SortColumnEvent.Mode mode = event.mode();
        this.licensesGrid.sortings(mode != SortColumnEvent.Mode.None ? List.of(column.name() + "=" + (mode == SortColumnEvent.Mode.Ascendant ? "A" : "D")) : Collections.emptyList());
    }
}

