/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.LanguageCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageInfoTemplate;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageProperty;

public class LanguageInfoTemplate
extends AbstractLanguageInfoTemplate<EditorBox> {
    private Language language;
    private String release;

    public LanguageInfoTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void release(String release) {
        this.release = release;
    }

    @Override
    public void init() {
        super.init();
        this.editorStamp.onChangeId(this::rename);
        this.editorStamp.onChangeLogo(e -> this.save(LanguageProperty.Logo, e));
    }

    public void refresh() {
        super.refresh();
        this.editorStamp.language(this.language);
        this.editorStamp.metamodel(((EditorBox)this.box()).modelManager().get(this.language.metamodel()));
        this.editorStamp.refresh();
        this.refreshProperties();
    }

    private void refreshProperties() {
        this.propertiesStamp.language(this.language);
        this.propertiesStamp.release(this.release);
        this.propertiesStamp.refresh();
    }

    private void rename(String newName) {
        if (((EditorBox)this.box()).languageManager().exists(Language.collectionFrom(newName), Language.nameFrom(newName))) {
            this.notifyUser("Could not rename language. Already exists a language in selected collection", UserMessage.Type.Error);
            return;
        }
        ((EditorBox)this.box()).commands(LanguageCommands.class).rename(this.language, newName, this.username());
    }

    private void save(LanguageProperty property, Object value) {
        ((EditorBox)this.box()).commands(LanguageCommands.class).save(this.language, property, value, this.username());
    }
}

