/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands.collection;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.util.LicenseGenerator;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.box.util.UserHelper;
import io.quassar.editor.model.Collection;
import io.quassar.editor.model.User;
import java.util.stream.IntStream;

public class AddLicensesCommand
extends Command<Boolean> {
    public Collection collection;
    public int count;
    public int duration;

    public AddLicensesCommand(EditorBox box) {
        super(box);
    }

    @Override
    public Boolean execute() {
        if (!PermissionsHelper.hasCredit(this.count * this.duration, this.author, this.box)) {
            return false;
        }
        IntStream.range(0, this.count).forEach(i -> this.box.collectionManager().createLicense(this.collection, LicenseGenerator.generate(), this.duration));
        User user = UserHelper.user(this.author, this.box);
        int licenseTime = UserHelper.licenseTime(this.author, this.box);
        user.licenseTime(licenseTime - this.count * this.duration);
        return true;
    }
}

