/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.LanguageCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageEditor;
import io.quassar.editor.box.ui.displays.templates.CreateCollectionDialog;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.model.Collection;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;

public class LanguageEditor
extends AbstractLanguageEditor<EditorBox> {
    private Language language;
    private Model metamodel;
    private Consumer<Boolean> checkIdListener;
    private Consumer<String> changeIdListener;
    private Consumer<File> changeLogoListener;
    private String selectedCollection = null;

    public LanguageEditor(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
        this.selectedCollection = null;
    }

    public void metamodel(Model metamodel) {
        this.metamodel = metamodel;
    }

    public void onCheckId(Consumer<Boolean> listener) {
        this.checkIdListener = listener;
    }

    public void onChangeId(Consumer<String> listener) {
        this.changeIdListener = listener;
    }

    public void onChangeLogo(Consumer<File> listener) {
        this.changeLogoListener = listener;
    }

    public String languageCollection() {
        return (String)this.collectionSelector.selection().getFirst();
    }

    public Collection collection() {
        List selection = this.collectionSelector.selection();
        return !selection.isEmpty() ? ((EditorBox)this.box()).collectionManager().get((String)selection.getFirst()) : null;
    }

    public String languageName() {
        return this.nameField.value();
    }

    public boolean isPrivate() {
        return this.privateField.state() == ToggleEvent.State.On;
    }

    public File logo() {
        return this.languageLogoDialog.logo();
    }

    public void focus() {
        this.nameField.focus();
    }

    public boolean check() {
        this.message.value(null);
        if (this.collectionSelector.selection().isEmpty()) {
            this.message.value(this.translate("Collection is required"));
            return false;
        }
        DisplayHelper.CheckResult result = DisplayHelper.checkLanguageName(this.nameField.value(), arg_0 -> ((LanguageEditor)this).translate(arg_0));
        if (!result.success()) {
            this.message.value(result.message());
            return false;
        }
        result = DisplayHelper.checkLanguageInUse((String)this.collectionSelector.selection().getFirst(), this.nameField.value(), arg_0 -> ((LanguageEditor)this).translate(arg_0), (EditorBox)this.box());
        if (!result.success()) {
            this.message.value(result.message());
            return false;
        }
        return true;
    }

    @Override
    public void init() {
        super.init();
        this.createCollectionDialog.onCreate(this::updateCollection);
        this.nameField.onEnterPress(e -> this.changeId());
        this.nameField.onChange(e -> this.refreshState());
        this.change.onCancelAffirmed(e -> this.collectionSelector.selection(new String[]{this.language.collection()}));
        this.change.onExecute(e -> this.changeId());
        this.languageLogoDialog.onChangeLogo(this::updateLogo);
        this.collectionSelector.onSelect(e -> this.updateCollection());
        this.privateField.onToggle(e -> this.updateAccess());
    }

    public void refresh() {
        super.refresh();
        if (this.user() == null) {
            return;
        }
        this.refreshCollectionSelector();
        this.nameField.value(this.language != null ? this.language.name() : this.metamodelTitle());
        this.nameField.readonly(this.language != null);
        this.privateField.state(this.language == null || this.language.isPrivate() ? ToggleEvent.State.On : ToggleEvent.State.Off);
        this.languageLogoDialog.language(this.language);
        this.languageLogoDialog.languageIdProvider(e -> this.languageId());
        this.languageLogoDialog.languageNameProvider(e -> this.nameField.value());
        this.languageLogoDialog.readonly(this.nameField.value() == null || this.nameField.value().isEmpty());
        this.languageLogoDialog.refresh();
        this.refreshState();
        if (this.language == null && this.nameField.value() != null && !this.nameField.value().isEmpty()) {
            this.languageLogoDialog.generateDefaultLogo();
        }
    }

    private String metamodelTitle() {
        String result = this.metamodel.title().contains(".") ? this.metamodel.title().substring(this.metamodel.title().lastIndexOf(".") + 1) : this.metamodel.title();
        return result.toLowerCase().replace("-", "");
    }

    private void refreshState() {
        boolean sameName = this.language == null || this.language.name().equals(this.nameField.value());
        boolean validCollection = !this.collectionSelector.selection().isEmpty();
        boolean sameCollection = this.language == null || validCollection && this.language.collection().equals(this.collectionSelector.selection().getFirst());
        boolean validName = sameName && DisplayHelper.checkLanguageName(this.nameField.value(), arg_0 -> ((LanguageEditor)this).translate(arg_0)).success() && (this.language != null || !this.collectionSelector.selection().isEmpty());
        boolean inUse = this.isInUse();
        this.refreshMessage(validCollection && (this.language == null || !sameCollection || !sameName));
        if (!sameName) {
            this.message.value(this.translate("DSL can't change its name once created"));
        }
        this.validNameIcon.visible(!inUse && validName);
        this.invalidNameIcon.visible(inUse || !validName);
        this.languageLogoDialog.readonly(this.nameField.value() == null || this.nameField.value().isEmpty());
        if (this.checkIdListener != null) {
            this.checkIdListener.accept(!inUse);
        }
    }

    private void changeId() {
        if (this.changeIdListener == null) {
            return;
        }
        this.notifyUser(this.translate("Updating DSL properties..."), UserMessage.Type.Loading);
        this.changeIdListener.accept(this.languageId());
        this.language = ((EditorBox)this.box()).languageManager().get(this.languageId());
        this.hideUserNotification();
        this.refresh();
    }

    private void refreshMessage(boolean checkInUse) {
        this.message.value(null);
        if (this.collectionSelector.selection().isEmpty()) {
            this.message.value("Collection is required");
            return;
        }
        if (this.nameField.value() == null || this.nameField.value().isEmpty()) {
            return;
        }
        DisplayHelper.CheckResult result = DisplayHelper.checkLanguageName(this.nameField.value(), arg_0 -> ((LanguageEditor)this).translate(arg_0));
        if (!result.success()) {
            this.message.value(result.message());
            return;
        }
        DisplayHelper.CheckResult checkResult = result = checkInUse ? DisplayHelper.checkLanguageInUse((String)this.collectionSelector.selection().getFirst(), this.nameField.value(), arg_0 -> ((LanguageEditor)this).translate(arg_0), (EditorBox)this.box()) : new DisplayHelper.CheckResult(true, null);
        if (!result.success()) {
            this.message.value(result.message());
        }
    }

    private void updateLogo(File file) {
        if (this.changeLogoListener != null) {
            this.changeLogoListener.accept(file);
        }
    }

    private String languageId() {
        String collection = (String)this.collectionSelector.selection().getFirst();
        if (collection == null) {
            return null;
        }
        return Language.key(collection, this.nameField.value());
    }

    private void updateCollection(Collection collection) {
        this.selectedCollection = collection.name();
        this.refreshCollectionSelector();
        this.refreshState();
    }

    private void updateCollection() {
        boolean inUse = this.isInUse();
        if (!this.sameLanguage() && !inUse && this.language != null) {
            this.change.launch();
        }
        this.selectedCollection = !this.collectionSelector.selection().isEmpty() ? (String)this.collectionSelector.selection().getFirst() : null;
        this.refreshCollectionSelector();
        this.refreshState();
    }

    private boolean sameLanguage() {
        boolean sameName = this.language != null && this.language.name().equals(this.nameField.value());
        boolean validCollection = !this.collectionSelector.selection().isEmpty();
        boolean sameCollection = this.language != null && validCollection && this.language.collection().equals(this.collectionSelector.selection().getFirst());
        return sameCollection && sameName;
    }

    private boolean isInUse() {
        boolean sameName = this.language == null || this.language.name().equals(this.nameField.value());
        boolean validCollection = !this.collectionSelector.selection().isEmpty();
        boolean sameCollection = this.language == null || validCollection && this.language.collection().equals(this.collectionSelector.selection().getFirst());
        return validCollection && (this.language == null || !sameCollection || !sameName) && !DisplayHelper.checkLanguageInUse((String)this.collectionSelector.selection().getFirst(), this.nameField.value(), arg_0 -> ((LanguageEditor)this).translate(arg_0), (EditorBox)this.box()).success();
    }

    private void refreshCollectionSelector() {
        List<String> options = ((EditorBox)this.box()).collectionManager().collections(this.username()).stream().map(Collection::name).toList();
        if (options.isEmpty()) {
            this.createCollectionDialog.mode(CreateCollectionDialog.Mode.FirstTime);
            this.createCollectionDialog.open();
        }
        this.collectionSelector.clear();
        this.collectionSelector.addAll(options);
        if (this.selectedCollection != null) {
            this.collectionSelector.selection(new String[]{this.selectedCollection});
        } else if (this.language != null) {
            this.collectionSelector.selection(new String[]{this.language.collection()});
        } else if (!options.isEmpty()) {
            this.collectionSelector.selection(new String[]{options.getFirst()});
        }
    }

    private void updateAccess() {
        if (this.language == null) {
            return;
        }
        if (this.privateField.state() == ToggleEvent.State.On) {
            ((EditorBox)this.box()).commands(LanguageCommands.class).makePrivate(this.language, this.username());
        } else {
            ((EditorBox)this.box()).commands(LanguageCommands.class).makePublic(this.language, this.username());
        }
    }
}

