/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.models;

import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.models.FileWriter;
import io.quassar.editor.box.models.Workspace;
import io.quassar.editor.box.models.WorkspaceReader;
import io.quassar.editor.box.models.writers.ModelWriter;
import io.quassar.editor.box.models.writers.ResourcesWriter;
import io.quassar.editor.box.util.WorkspaceHelper;
import io.quassar.editor.model.Model;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;

public class WorkspaceWriter {
    private final Workspace workspace;
    private final LanguageServer server;

    public WorkspaceWriter(Workspace workspace, LanguageServer server) {
        this.workspace = workspace;
        this.server = server;
    }

    public void clone(Model destinyModel, LanguageServer destinyServer) {
        try {
            if (destinyServer == null) {
                return;
            }
            Either symbols = (Either)this.server.getWorkspaceService().symbol(new WorkspaceSymbolParams()).get();
            List<File> files = WorkspaceHelper.filesOf((List)symbols.getRight());
            WorkspaceWriter writer = new WorkspaceWriter(this.workspace.clone(destinyModel), destinyServer);
            files.stream().filter(f -> !f.isDirectory()).forEach(f -> writer.createFile(f.uri(), this.content(f.uri()), null));
        }
        catch (InterruptedException | ExecutionException e) {
            Logger.error((Throwable)e);
        }
    }

    public File createFile(String filename, InputStream content, File parent) {
        return this.writer(filename).create(filename, content, parent);
    }

    public File createFolder(String name, File parent) {
        return this.writer(name).createFolder(name, parent);
    }

    public void save(File file, InputStream content) {
        this.writer(file.uri()).save(file, content);
    }

    public File rename(File file, String newName) {
        return this.writer(file.uri()).rename(file, newName);
    }

    public File move(File file, File directory) {
        return this.writer(file.uri()).move(file, directory);
    }

    public File copy(String filename, File source) {
        return this.writer(filename).copy(filename, source);
    }

    public void remove(File file) {
        this.writer(file.uri()).remove(file);
    }

    private InputStream content(String uri) {
        return new WorkspaceReader(this.workspace, this.server).content(uri);
    }

    private FileWriter writer(String uri) {
        return File.isResource(uri) ? new ResourcesWriter(this.workspace) : new ModelWriter(this.workspace, this.server);
    }
}

