/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.UserMessage;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.LanguageCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageExecutionTemplate;
import io.quassar.editor.box.ui.displays.templates.DependencyTemplate;
import io.quassar.editor.box.ui.displays.templates.DownloadTemplate;
import io.quassar.editor.box.ui.displays.templates.LinkTemplate;
import io.quassar.editor.box.util.Formatters;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageExecution;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;

public class LanguageExecutionTemplate
extends AbstractLanguageExecutionTemplate<EditorBox> {
    private Language language;
    private String release;
    private Consumer<Command.CommandResult> createVersionListener;
    private static final List<String> ExamplesCodeUsage = List.of("model in Quassar", "local file", "text string");
    private static final List<String> Languages = List.of("Docker", "Maven", "Python", "Custom");
    private static final Map<String, String> InstallationUrls = Map.of("Docker", "https://docs.docker.com/engine/install/", "Maven", "https://maven.apache.org/install.html", "Python", "https://docs.python.org");

    public LanguageExecutionTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void release(String release) {
        this.release = release;
    }

    public void onCreateVersion(Consumer<Command.CommandResult> listener) {
        this.createVersionListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.createVersion.onExecute(e -> this.createVersion());
        this.nameField.onChange(e -> this.saveName());
        this.exampleCodeField.onChange(e -> this.copyExampleCodeUsage.text((String)e.value()));
        this.executionSelector.onSelect(e -> this.saveType());
        this.localEnvironmentBlock.onInit(e -> this.initLocalEnvironmentBlock());
        this.localEnvironmentBlock.onShow(e -> this.refreshLocalEnvironmentBlock());
        this.remoteEnvironmentBlock.onInit(e -> this.initRemoteEnvironmentBlock());
        this.remoteEnvironmentBlock.onShow(e -> this.refreshRemoteEnvironmentBlock());
    }

    public void refresh() {
        super.refresh();
        boolean hasCommits = this.hasCommits();
        this.selectVersionBlock.visible(this.release == null && this.language != null);
        this.versionBlock.visible(this.release != null && this.release() != null);
        this.versionNotCreatedBlock.visible(this.release != null && this.release() == null && hasCommits);
        this.refreshNoVersionsBlock(hasCommits);
        if (!this.versionBlock.isVisible()) {
            return;
        }
        LanguageExecution execution = this.execution();
        this.nameField.value(execution != null ? execution.name() : null);
        this.refreshDownloads();
        this.refreshMavenDependencies();
        this.refreshExamplesCodeUsage();
        this.refreshExecutionEnvironment();
    }

    private boolean hasCommits() {
        if (this.language == null) {
            return false;
        }
        Model metamodel = ((EditorBox)this.box()).modelManager().get(this.language.metamodel());
        return metamodel != null && !metamodel.releases().isEmpty();
    }

    private void refreshNoVersionsBlock(boolean hasCommits) {
        this.noVersionsBlock.visible(this.language != null && !hasCommits);
        if (!this.noVersionsBlock.isVisible()) {
            return;
        }
        Model metamodel = ((EditorBox)this.box()).modelManager().get(this.language.metamodel());
        this.metamodelLink.site(PathHelper.modelUrl(metamodel, this.session()));
    }

    private void refreshDownloads() {
        File graphFile = ((EditorBox)this.box()).languageManager().loadGraph(this.language, this.release());
        this.downloadsBlock.visible(false);
        if (!this.downloadsBlock.isVisible()) {
            return;
        }
        this.downloads.clear();
        this.fill(graphFile, (DownloadTemplate)this.downloads.add());
    }

    private void refreshMavenDependencies() {
        this.dependencies.clear();
        ((EditorBox)this.box()).languageManager().loadParsers(this.language, this.release()).forEach(r -> this.fill((File)r, (DependencyTemplate)this.dependencies.add()));
    }

    private void refreshExamplesCodeUsage() {
        this.examplesCodeUsage.clear();
        ExamplesCodeUsage.forEach(l -> this.fillExampleCodeUsage((String)l, (LinkTemplate)this.examplesCodeUsage.add()));
        this.updateExampleCodeUsage(ExamplesCodeUsage.getFirst());
    }

    private void refreshExecutionEnvironment() {
        LanguageExecution execution = this.execution();
        if (execution == null) {
            execution = ((EditorBox)this.box()).commands(LanguageCommands.class).createExecution(this.language, this.release, this.nameField.value(), LanguageExecution.Type.None, this.username());
        }
        this.executionSelector.select(execution.type().name().toLowerCase() + "Option");
    }

    private void fill(File file, DownloadTemplate display) {
        display.language(this.language);
        display.release(this.release);
        display.file(file);
        display.refresh();
    }

    private void fill(File file, DependencyTemplate display) {
        display.language(this.language);
        display.release(this.release);
        display.file(file);
        display.refresh();
    }

    private void createVersion() {
        this.notifyUser("Creating version...", UserMessage.Type.Loading);
        this.createVersion.readonly(true);
        this.createVersionListener.accept(((EditorBox)this.box()).commands(LanguageCommands.class).createRelease(this.language, this.release, this.username()));
        this.createVersion.readonly(false);
        this.hideUserNotification();
    }

    private void saveName() {
        LanguageExecution execution = this.execution();
        ((EditorBox)this.box()).commands(LanguageCommands.class).saveExecution(this.language, this.release, this.nameField.value(), execution != null ? execution.type() : LanguageExecution.Type.None, execution != null ? execution.content(execution.type()) : "", this.username());
    }

    private void saveType() {
        LanguageExecution execution;
        LanguageExecution.Type selected = this.selectedExecution();
        ((EditorBox)this.box()).commands(LanguageCommands.class).saveExecution(this.language, this.release, (execution = this.execution()) != null ? execution.name() : null, selected, execution != null ? execution.content(selected) : "", this.username());
    }

    private LanguageExecution.Type selectedExecution() {
        List selection = this.executionSelector.selection();
        if (selection.isEmpty()) {
            return LanguageExecution.Type.None;
        }
        String selected = (String)selection.getFirst();
        return LanguageExecution.Type.valueOf(Formatters.firstUpperCase(selected).replace("Option", ""));
    }

    private void initLocalEnvironmentBlock() {
        this.localField.onChange(e -> this.saveLocalConfiguration((String)e.value()));
        this.installationField.onChange(e -> this.saveInstallationUrl((String)e.value()));
    }

    private String templateContent(String language) {
        try {
            InputStream stream = LanguageExecutionTemplate.class.getResourceAsStream("/templates/execution/%s.tpl".formatted(language));
            if (stream == null) {
                return "";
            }
            return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return "";
        }
    }

    private String exampleCodeUsageContent(String name) {
        try {
            InputStream stream = LanguageExecutionTemplate.class.getResourceAsStream("/templates/examples-code-usage/%s.tpl".formatted(name.toLowerCase().replace(" ", "-")));
            if (stream == null) {
                return "";
            }
            return this.replaceVars(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return "";
        }
    }

    private String replaceVars(String content) {
        content = content.replace("::dsl::", Formatters.firstUpperCase(this.language.name()));
        content = content.replace("::dslLower::", this.language.name().toLowerCase());
        content = content.replace("::commitUrl::", PathHelper.commitUrl(this.session()));
        return content;
    }

    private void refreshLocalEnvironmentBlock() {
        LanguageExecution execution = this.execution();
        this.localField.value(execution != null ? execution.content(LanguageExecution.Type.Local) : null);
        this.installationField.value(execution != null ? execution.installationUrl() : null);
        this.exampleTemplates.clear();
        Languages.forEach(l -> this.fill((String)l, (LinkTemplate)this.exampleTemplates.add()));
    }

    private void fill(String language, LinkTemplate display) {
        display.linkTitle(language);
        display.onClick(e -> this.insertTemplate(language));
        display.refresh();
    }

    private void fillExampleCodeUsage(String exampleCodeUsage, LinkTemplate display) {
        display.linkTitle(exampleCodeUsage);
        display.onClick(e -> this.updateExampleCodeUsage(exampleCodeUsage));
        display.refresh();
    }

    private void insertTemplate(String templateLanguage) {
        if (templateLanguage == null) {
            return;
        }
        this.localField.value(this.templateContent(templateLanguage));
        this.saveLocalConfiguration(this.localField.value());
        this.localField.focus();
        if (this.installationField.value() != null && !this.installationField.value().isEmpty() && InstallationUrls.values().stream().noneMatch(i -> i.equalsIgnoreCase(this.installationField.value()))) {
            return;
        }
        this.installationField.value(this.defaultInstallation(templateLanguage));
    }

    private void updateExampleCodeUsage(String name) {
        String value = this.exampleCodeUsageContent(name);
        this.copyExampleCodeUsage.text(value);
        this.exampleCodeField.value(value);
    }

    private String defaultInstallation(String templateLanguage) {
        return InstallationUrls.getOrDefault(templateLanguage, "");
    }

    private void initRemoteEnvironmentBlock() {
        this.remoteField.onChange(e -> this.saveRemoteConfiguration((String)e.value()));
        this.copyRemoteExample.onExecute(e -> {
            this.remoteField.value("https://your-application.com/run?model=[commit]");
            this.remoteField.focus();
        });
    }

    private void refreshRemoteEnvironmentBlock() {
        LanguageExecution execution = this.execution();
        this.remoteField.value(execution != null ? execution.content(LanguageExecution.Type.Remote) : null);
    }

    private void saveRemoteConfiguration(String content) {
        LanguageExecution execution = this.execution();
        String name = execution != null ? execution.name() : null;
        ((EditorBox)this.box()).commands(LanguageCommands.class).saveExecution(this.language, this.release, name, LanguageExecution.Type.Remote, content, this.username());
        this.remoteField.error(this.errorMessage(content));
    }

    private void saveLocalConfiguration(String content) {
        LanguageExecution execution = this.execution();
        String name = execution != null ? execution.name() : null;
        ((EditorBox)this.box()).commands(LanguageCommands.class).saveExecution(this.language, this.release, name, LanguageExecution.Type.Local, content, this.username());
        this.localField.error(this.errorMessage(content));
    }

    private void saveInstallationUrl(String url) {
        ((EditorBox)this.box()).commands(LanguageCommands.class).saveExecutionProperties(this.language, this.release, url, this.username());
    }

    private LanguageExecution execution() {
        LanguageRelease languageRelease = this.language.release(this.release);
        return languageRelease != null ? languageRelease.execution() : null;
    }

    private String errorMessage(String content) {
        String data;
        String string = data = content != null ? content.toLowerCase() : "";
        if (!data.contains("[commit]") && !data.contains("[commit-url]")) {
            return this.translate("Invalid command. Make sure it includes [commit] or [commit-url] placeholder.");
        }
        return null;
    }

    private LanguageRelease release() {
        return this.language.release(this.release);
    }
}

