/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.model;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Utilities {
    private Set<String> records = new HashSet<String>();
    private final File file;

    public Utilities(File file) {
        this.file = file;
        this.load();
    }

    public List<String> all() {
        return new ArrayList<String>(this.records);
    }

    public void add(String utility) {
        this.records.add(utility);
        this.save();
    }

    private void save() {
        try {
            Files.writeString(this.file.toPath(), (CharSequence)String.join((CharSequence)"\n", this.records), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void load() {
        try {
            if (!this.file.exists()) {
                return;
            }
            this.records = new HashSet<String>(Files.readAllLines(this.file.toPath()));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }
}

