/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractLicenseDialog;
import io.quassar.editor.model.License;
import java.util.function.Consumer;

public class LicenseDialog
extends AbstractLicenseDialog<EditorBox> {
    private License license;
    private Consumer<License> renewListener;

    public LicenseDialog(EditorBox box) {
        super(box);
    }

    public void license(License license) {
        this.license = license;
    }

    public void onRenew(Consumer<License> listener) {
        this.renewListener = listener;
    }

    public void open() {
        this.dialog.open();
    }

    @Override
    public void init() {
        super.init();
        this.dialog.onOpen(e -> this.refreshDialog());
        this.renewDialog.onRenew(e -> this.renewListener.accept((License)e));
        this.renew.onExecute(e -> this.openRenewDialog());
    }

    private void refreshDialog() {
        this.message.value(this.message());
        this.renew.visible(this.license != null);
    }

    private String message() {
        if (this.license == null) {
            return "You don't have a license to use this language";
        }
        if (this.license.isExpired()) {
            return "Your license has expired. Please renew it to continue using this language";
        }
        return null;
    }

    private void openRenewDialog() {
        this.dialog.close();
        this.renewDialog.license(this.license);
        this.renewDialog.open();
    }
}

