/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageTemplate;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.box.util.SessionHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;

public class LanguageTemplate
extends AbstractLanguageTemplate<EditorBox> {
    private Language language;
    private LanguageRelease release;
    private LanguageTab tab;

    public LanguageTemplate(EditorBox box) {
        super(box);
    }

    public void open(String language, String tab) {
        this.language = ((EditorBox)this.box()).languageManager().get(language);
        this.release = null;
        this.tab = tab != null ? LanguageTab.from(tab) : LanguageTab.About;
        this.refresh();
    }

    public void openTab(String tab) {
        if (SessionHelper.isRightPanelCollapsed(this.session())) {
            this.expandHome();
        }
        this.tab = tab != null ? LanguageTab.from(tab) : LanguageTab.About;
        this.refreshHeader();
        this.refreshViews(false);
    }

    public void openHelp(String language, String version) {
        this.language = ((EditorBox)this.box()).languageManager().get(language);
        this.release = this.language.release(version);
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.helpBlock.onShow(e -> this.refreshHelpBlock());
        this.mainBlock.onInit(e -> this.initMainBlock());
        this.mainBlock.onShow(e -> this.refreshMainBlock());
    }

    public void refresh() {
        super.refresh();
        this.notFoundBlock.visible(!PermissionsHelper.hasPermissions(this.language, this.session(), (EditorBox)this.box()));
        this.refreshHeader();
        this.refreshBlocks();
    }

    private void refreshBlocks() {
        if (!PermissionsHelper.hasPermissions(this.language, this.session(), (EditorBox)this.box())) {
            this.mainBlock.hide();
            this.helpBlock.hide();
            return;
        }
        if (this.release != null) {
            this.mainBlock.hide();
            this.helpBlock.show();
        } else {
            this.helpBlock.hide();
            this.mainBlock.show();
        }
    }

    private void refreshHelpBlock() {
        this.helpTitle.value(this.translate(LanguageHelper.title(LanguageTab.Help)).formatted(LanguageHelper.title(GavCoordinates.fromString(this.language, this.release)), this.release.version()));
        this.helpLogo.value(LanguageHelper.logo(this.language, (EditorBox)this.box()));
        String content = ((EditorBox)this.box()).languageManager().loadHelp(this.language, this.release);
        this.helpStamp.content("<div class='help'>" + content + "</div>");
        this.helpStamp.refresh();
    }

    private void initMainBlock() {
        this.languageExplorer.onExpand(e -> this.expandHome());
        this.languageExplorer.onCollapse(e -> this.collapseHome());
        this.mainBlock.mainContentBlock.homeBlock.onShow(e -> this.refreshViews(true));
        this.mainBlock.mainContentBlock.modelsBlock.onShow(e -> this.refreshModels());
        this.mainBlock.mainContentBlock.modelsBlock.modelsStamp.onCreateModel(e -> this.createModel());
    }

    private void expandHome() {
        this.mainBlock.mainContentBlock.refreshLayout(new Integer[]{55, 45});
        SessionHelper.registerRightPanelExpanded(this.session());
    }

    private void collapseHome() {
        this.mainBlock.mainContentBlock.refreshLayout(new Integer[]{95, 4});
        SessionHelper.registerRightPanelCollapsed(this.session());
    }

    private void refreshMainBlock() {
        this.mainBlock.notLoggedBlock.visible(this.user() == null);
        this.licenseExpiredBanner.language(this.language);
        this.licenseExpiredBanner.hint("This language is read-only. Editing is disabled");
        this.licenseExpiredBanner.refresh();
        this.refreshViews(true);
        this.refreshModels();
    }

    private void refreshHeader() {
        this.headerStamp.visible(this.release == null && PermissionsHelper.hasPermissions(this.language, this.session(), (EditorBox)this.box()));
        if (!this.headerStamp.isVisible()) {
            return;
        }
        this.headerStamp.language(this.language);
        this.headerStamp.tab(this.tab);
        this.headerStamp.refresh();
    }

    private void refreshViews(boolean invalidate) {
        this.languageExplorer.invalidateCache(invalidate);
        this.languageExplorer.language(this.language);
        this.languageExplorer.release(this.release != null ? this.release.version() : (this.language.lastRelease() != null ? this.language.lastRelease().version() : null));
        this.languageExplorer.tab(this.tab);
        this.languageExplorer.refresh();
        if (SessionHelper.isRightPanelCollapsed(this.session())) {
            this.mainBlock.mainContentBlock.refreshLayout(new Integer[]{95, 4});
        }
    }

    private void refreshModels() {
        this.mainBlock.mainContentBlock.modelsBlock.modelsStamp.language(this.language);
        this.mainBlock.mainContentBlock.modelsBlock.modelsStamp.bindTo(this.modelsDialog);
        this.mainBlock.mainContentBlock.modelsBlock.modelsStamp.refresh();
    }

    private Model createModel() {
        LanguageRelease release = this.language.lastRelease();
        String name = ModelHelper.proposeName();
        return ((EditorBox)this.box()).commands(ModelCommands.class).create(name, name, "", GavCoordinates.fromString(this.language, release), DisplayHelper.user(this.session()), this.username());
    }
}

