/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.utils.DelayerUtil;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.LanguageCommands;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.ui.displays.HelpEditor;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageKitTemplate;
import io.quassar.editor.box.ui.displays.templates.ModelsTemplate;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.util.function.Consumer;

public class LanguageKitTemplate
extends AbstractLanguageKitTemplate<EditorBox> {
    private Language language;
    private String release;
    private Consumer<Command.CommandResult> createVersionListener;

    public LanguageKitTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void release(String release) {
        this.release = release;
    }

    public void onCreateVersion(Consumer<Command.CommandResult> listener) {
        this.createVersionListener = listener;
    }

    public void notifyRemove(Model model) {
        this.modelsCatalog.refresh();
    }

    public void notifyChange(Model model) {
        if (!model.isExample()) {
            return;
        }
        if (model.language().languageId().equals(this.language.name())) {
            return;
        }
        this.modelsCatalog.refresh(model);
    }

    @Override
    public void init() {
        super.init();
        this.createVersion.onExecute(e -> this.createVersion());
        this.createTemplate.onExecute(e -> this.createTemplate());
        this.helpDialog.onOpen(e -> this.refreshHelpDialog());
        this.examplesDialog.onOpen(e -> this.refreshExamplesDialog());
        this.modelsCatalog.onBeforeOpenModel(e -> DelayerUtil.execute((Display)this, e1 -> this.examplesDialog.close(), (int)1000));
        this.modelsCatalog.onCreateModel(e -> this.createModel());
        this.startModeling.onExecute(e -> this.startModeling());
    }

    public void refresh() {
        super.refresh();
        boolean hasCommits = this.hasCommits();
        this.selectVersionBlock.visible(this.release == null && this.language != null);
        this.versionBlock.visible(this.release != null && this.release() != null);
        this.versionNotCreatedBlock.visible(this.release != null && this.release() == null && hasCommits);
        this.refreshNoVersionsBlock(hasCommits);
        if (!this.versionBlock.isVisible()) {
            return;
        }
        this.refreshTemplate();
    }

    private boolean hasCommits() {
        if (this.language == null) {
            return false;
        }
        Model metamodel = ((EditorBox)this.box()).modelManager().get(this.language.metamodel());
        return metamodel != null && !metamodel.releases().isEmpty();
    }

    private void refreshNoVersionsBlock(boolean hasCommits) {
        this.noVersionsBlock.visible(this.language != null && !hasCommits);
        if (!this.noVersionsBlock.isVisible()) {
            return;
        }
        Model metamodel = ((EditorBox)this.box()).modelManager().get(this.language.metamodel());
        this.metamodelLink.site(PathHelper.modelUrl(metamodel, this.session()));
    }

    private void refreshTemplate() {
        String templateId = this.release().template();
        Model template = templateId != null ? ((EditorBox)this.box()).modelManager().get(templateId) : null;
        this.templateDefined.visible(template != null);
        this.templateNotDefined.visible(template == null);
        if (template == null) {
            return;
        }
        this.templateLink.site(PathHelper.modelUrl(template, "draft", this.session()));
    }

    private void refreshExamples() {
        this.modelsCatalog.language(this.language);
        this.modelsCatalog.mode(ModelsTemplate.Mode.Forge);
        this.modelsCatalog.release(this.release());
        this.modelsCatalog.tab(LanguageTab.Examples);
        this.modelsCatalog.bindTo(this.modelsDialog);
        this.modelsCatalog.refresh();
    }

    private void createVersion() {
        this.notifyUser("Creating version...", UserMessage.Type.Loading);
        this.createVersion.readonly(true);
        this.createVersionListener.accept(((EditorBox)this.box()).commands(LanguageCommands.class).createRelease(this.language, this.release, this.username()));
        this.createVersion.readonly(false);
        this.hideUserNotification();
    }

    private LanguageRelease release() {
        return this.language.release(this.release);
    }

    private void createTemplate() {
        ((EditorBox)this.box()).commands(ModelCommands.class).createTemplate(this.language, this.release(), this.username());
        this.refreshTemplate();
    }

    private Model createModel() {
        Model result = ((EditorBox)this.box()).commands(ModelCommands.class).createExample(this.language, this.release(), this.username());
        DelayerUtil.execute((Display)this, e1 -> this.examplesDialog.close(), (int)1000);
        return result;
    }

    private void refreshHelpDialog() {
        this.helpDialog.title(this.translate("Edit help for %s release").formatted(this.release));
        this.helpEditor.clear();
        HelpEditor display = new HelpEditor((EditorBox)this.box());
        this.helpEditor.display(display);
        display.language(this.language);
        display.release(this.release);
        display.refresh();
    }

    private void startModeling() {
        this.openModel.site(PathHelper.languageUrl(this.language, this.session()));
        this.openModel.launch();
    }

    private void refreshExamplesDialog() {
        this.examplesDialog.title(this.translate("Examples of %s %s").formatted(this.language.name(), this.release));
        this.refreshExamples();
    }
}

