/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.CollectionCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractCreateCollectionDialog;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.model.Collection;
import java.util.function.Consumer;

public class CreateCollectionDialog
extends AbstractCreateCollectionDialog<EditorBox> {
    private Consumer<Collection> createListener;

    public CreateCollectionDialog(EditorBox box) {
        super(box);
    }

    public void onCreate(Consumer<Collection> listener) {
        this.createListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.nameField.onEnterPress(e -> this.create());
        this.nameField.onChange(e -> this.refreshState());
        this.create.onExecute(e -> this.create());
        this.dialog.onOpen(e -> this.refreshDialog());
    }

    private void refreshDialog() {
        this.nameField.error(null);
        this.nameField.value(null);
        this.nameField.focus();
        this.validIcon.visible(false);
        this.invalidIcon.visible(false);
    }

    private void refreshState() {
        DisplayHelper.CheckResult result = DisplayHelper.checkCollectionName(this.nameField.value(), arg_0 -> ((CreateCollectionDialog)this).translate(arg_0), (EditorBox)this.box());
        this.nameField.error(!result.success() ? result.message() : null);
        this.validIcon.visible(result.success());
        this.invalidIcon.visible(!result.success());
    }

    private void create() {
        this.nameField.error(null);
        DisplayHelper.CheckResult result = DisplayHelper.checkCollectionName(this.nameField.value(), arg_0 -> ((CreateCollectionDialog)this).translate(arg_0), (EditorBox)this.box());
        if (!result.success()) {
            this.nameField.error(result.message());
            return;
        }
        this.dialog.close();
        Collection collection = ((EditorBox)this.box()).commands(CollectionCommands.class).create(this.nameField.value(), Collection.SubscriptionPlan.Professional, this.username());
        this.createListener.accept(collection);
    }
}

