/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.util;

import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class LicenseGenerator {
    private static final SecureRandom Random = new SecureRandom();
    private static final char[] Base = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
    private static final long EpochSeconds = LocalDateTime.of(2025, 1, 1, 0, 0).toEpochSecond(ZoneOffset.UTC);
    private static final int SIZE = 9;
    private static final int[] order = new int[]{6, 3, 0, 1, 7, 2, 8, 4, 5};

    public static String generate() {
        return LicenseGenerator.generate(LicenseGenerator.value());
    }

    public static int size() {
        return 10;
    }

    private static String generate(long value) {
        char[] chars = new char[9];
        for (int i = 8; i >= 0; --i) {
            chars[i] = Base[(int)(value % (long)Base.length)];
            value /= (long)Base.length;
        }
        return LicenseGenerator.addChecksumTo(LicenseGenerator.mix(chars));
    }

    private static String addChecksumTo(String license) {
        return license + LicenseGenerator.checksum(license);
    }

    private static long value() {
        return LicenseGenerator.seconds() << 18 | LicenseGenerator.random();
    }

    private static char checksum(String license) {
        int sum = 0;
        for (int i = 0; i < license.length(); ++i) {
            sum += license.charAt(i);
        }
        return Base[sum % Base.length];
    }

    private static String mix(char[] chars) {
        char[] result = new char[9];
        for (int i = 0; i < 9; ++i) {
            result[i] = chars[order[i]];
        }
        return new String(result);
    }

    private static long random() {
        return Random.nextInt(262144);
    }

    private static long seconds() {
        return Instant.now().getEpochSecond() - EpochSeconds;
    }

    public static void main(String[] args) {
        System.out.println(LicenseGenerator.generate());
    }
}

