/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.actions;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.Forbidden;
import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.actions.QuassarAction;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.model.Model;
import io.quassar.editor.model.ModelRelease;
import java.io.InputStream;

public class GetDownloadModelFileAction
extends QuassarAction {
    public String commit;
    public String file;

    public Resource execute() throws Forbidden {
        Model model = this.box.modelManager().find(this.commit);
        ModelRelease release = this.box.modelManager().findRelease(this.commit);
        if (model == null || release == null) {
            Logger.error((String)"Model commit %s not found".formatted(model));
            return DisplayHelper.emptyFile();
        }
        try {
            InputStream content = this.box.modelManager().content(model, release.version(), this.file);
            return new Resource(this.file, content);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return DisplayHelper.emptyFile();
        }
    }
}

