/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.CollectionCommands;
import io.quassar.editor.box.commands.collection.RenewLicenseCommand;
import io.quassar.editor.box.ui.displays.templates.AbstractRenewLicenseDialog;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.box.util.UserHelper;
import io.quassar.editor.model.License;
import java.util.function.Consumer;

public class RenewLicenseDialog
extends AbstractRenewLicenseDialog<EditorBox> {
    private License license;
    private Consumer<License> renewListener;

    public RenewLicenseDialog(EditorBox box) {
        super(box);
    }

    public void license(License license) {
        this.license = license;
    }

    public void onRenew(Consumer<License> listener) {
        this.renewListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.dialog.onOpen(e -> this.refreshDialog());
        this.renew.onExecute(e -> this.renew());
    }

    public void open() {
        this.renew();
    }

    private void refreshDialog() {
        boolean hasCredit = PermissionsHelper.hasCredit(this.renewPeriod(), this.session(), (EditorBox)this.box());
        this.renew.readonly(!hasCredit);
        this.message.value(this.message(hasCredit));
    }

    private String message(boolean hasCredit) {
        if (!hasCredit) {
            return this.translate("You don't have enough credit to renew this license");
        }
        int remainingPeriod = UserHelper.licenseTime(this.session(), (EditorBox)this.box()) - this.renewPeriod();
        return this.translate("This license will be renewed for %s months. Your remaining credit will be: %s months").formatted(this.renewPeriod(), remainingPeriod);
    }

    private int renewPeriod() {
        return Integer.parseInt(((EditorBox)this.box()).configuration().renewLicenseTimeDuration());
    }

    private void renew() {
        RenewLicenseCommand.RenewResult result = ((EditorBox)this.box()).commands(CollectionCommands.class).renew(this.license, this.renewPeriod(), this.username());
        if (!result.success()) {
            this.notifyUser(result.message(), UserMessage.Type.Error);
            return;
        }
        this.dialog.close();
        this.renewListener.accept(this.license);
    }
}

