/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.AddCollectionItemEvent;
import io.intino.alexandria.ui.model.Datasource;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.datasources.LanguagesDatasource;
import io.quassar.editor.box.ui.displays.items.LanguageLandingItem;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguagesLandingTemplate;
import io.quassar.editor.box.ui.types.LanguagesTab;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.SessionHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LogoSize;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class LanguagesLandingTemplate
extends AbstractLanguagesLandingTemplate<EditorBox> {
    private LanguagesTab tab;
    private Consumer<Language> selectListener;

    public LanguagesLandingTemplate(EditorBox box) {
        super(box);
    }

    public void open(String tab) {
        this.tab = tab != null ? LanguagesTab.from(tab) : SessionHelper.languagesTab(this.session());
        this.refresh();
    }

    public void filter(String condition) {
        this.languagesLandingCatalog.filter(condition);
    }

    public void filter(String grouping, List<String> values) {
        this.languagesLandingCatalog.filter(grouping, values);
    }

    public void onSelect(Consumer<Language> listener) {
        this.selectListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.languagesLandingCatalog.onAddItem(this::refresh);
        this.searchBox.onEnterPress(e -> this.filter((String)e.value()));
        this.searchBox.onChange(e -> this.filter((String)e.value()));
    }

    public void refresh() {
        super.refresh();
        this.refreshLanguages();
    }

    private void refreshLanguages() {
        LanguagesDatasource source = new LanguagesDatasource((EditorBox)this.box(), this.session());
        this.languagesLandingCatalog.source((Datasource)source);
        this.searchBox.visible(source.itemCount(null, Collections.emptyList()) > DisplayHelper.MinItemsCount);
    }

    private void refresh(AddCollectionItemEvent event) {
        Language language = (Language)event.item();
        LanguageLandingItem item = (LanguageLandingItem)event.component();
        item.logo.value(LanguageHelper.logo(language, LogoSize.S50, (EditorBox)this.box()));
        this.refreshLogo(language, item);
        this.refreshLogoSelector(language, item);
        this.refreshName(language, item);
        this.refreshNameSelector(language, item);
        item.title.value(language.title());
        item.description.value(language.description());
    }

    private void refreshLogo(Language language, LanguageLandingItem item) {
        item.logoLink.visible(this.selectListener == null);
        if (!item.logoLink.isVisible()) {
            return;
        }
        item.logoLink.address(path -> PathHelper.languagePath(path, language));
    }

    private void refreshName(Language language, LanguageLandingItem item) {
        item.name.visible(this.selectListener == null);
        if (!item.name.isVisible()) {
            return;
        }
        item.name.title(LanguageHelper.label(language, arg_0 -> ((LanguagesLandingTemplate)this).translate(arg_0)));
        item.name.address(path -> PathHelper.languagePath(path, language));
    }

    private void refreshLogoSelector(Language language, LanguageLandingItem item) {
        item.logoSelectorLink.visible(this.selectListener != null);
        if (!item.logoSelectorLink.isVisible()) {
            return;
        }
        item.logoSelectorLink.onExecute(e -> this.notifySelect(language));
    }

    private void refreshNameSelector(Language language, LanguageLandingItem item) {
        item.nameSelector.visible(this.selectListener != null);
        if (!item.nameSelector.isVisible()) {
            return;
        }
        item.nameSelector.title(LanguageHelper.label(language, arg_0 -> ((LanguagesLandingTemplate)this).translate(arg_0)));
        item.nameSelector.onExecute(e -> this.notifySelect(language));
    }

    private void notifySelect(Language language) {
        this.selectListener.accept(language);
    }
}

