/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.intino.alexandria.ui.services.push.User;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractForgeHeaderTemplate;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LogoSize;
import io.quassar.editor.model.Model;

public class ForgeHeaderTemplate
extends AbstractForgeHeaderTemplate<EditorBox> {
    private Language language;
    private String release;
    private Model model;
    private boolean appInForge;

    public ForgeHeaderTemplate(EditorBox box) {
        super(box);
    }

    public void model(Model value) {
        this.model = value;
    }

    @Override
    public void init() {
        super.init();
        this.login.onExecute(e -> {
            this.session().add("callback", this.session().browser().requestUrl());
            if (((EditorBox)this.box()).authService() == null) {
                ((TemplateNotifier)this.notifier).redirect(PathHelper.loginUrl(this.session()));
            } else {
                ((TemplateNotifier)this.notifier).redirect(this.session().login(this.session().browser().baseUrl()));
            }
        });
    }

    public void refresh() {
        super.refresh();
        Language language = this.model != null ? ((EditorBox)this.box()).languageManager().get(this.model) : null;
        User loggedUser = this.session().user();
        this.logo.value(LanguageHelper.logo(language, LogoSize.S100, (EditorBox)this.box()));
        this.homeLink.site(PathHelper.homeUrl(this.session()));
        this.aboutLink.site(PathHelper.aboutUrl(this.session()));
        this.projectsLink.site(PathHelper.homeUrl(this.session()));
        this.forgeTitle.value("%s DSL forge".formatted(language != null ? language.key() : ""));
        this.login.visible(loggedUser == null);
        this.user.visible(loggedUser != null);
    }
}

