/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands.language;

import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;

public class RenameLanguageCommand
extends Command<Language> {
    public Language language;
    public String newId;

    public RenameLanguageCommand(EditorBox box) {
        super(box);
    }

    @Override
    public Language execute() {
        String oldKey = this.language.key();
        if (this.box.languageManager().exists(Language.collectionFrom(this.newId), Language.nameFrom(this.newId))) {
            return this.language;
        }
        if (oldKey.equalsIgnoreCase(this.newId)) {
            return this.language;
        }
        boolean renamed = this.renameLanguage();
        if (renamed) {
            this.updateModelsWithLanguage(oldKey);
        }
        return this.box.languageManager().get(this.newId);
    }

    private boolean renameLanguage() {
        try {
            File currentFolder = this.box.archetype().languages().get(this.language.key());
            File newFolder = this.box.archetype().languages().get(this.newId());
            Files.move(currentFolder.toPath(), newFolder.toPath(), new CopyOption[0]);
            this.box.languageManager().rename(this.language, this.newId());
            return true;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    private void updateModelsWithLanguage(String oldKey) {
        List<Model> models = this.box.modelManager().models(Language.collectionFrom(oldKey), Language.nameFrom(oldKey));
        models.forEach(m -> m.language(new GavCoordinates(Language.collectionFrom(this.newId()), this.language.name(), m.language().version())));
    }

    private String newId() {
        return this.newId.toLowerCase();
    }
}

