/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractDownloadTemplate;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.model.Language;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class DownloadTemplate
extends AbstractDownloadTemplate<EditorBox> {
    private Language language;
    private String release;
    private File file;

    public DownloadTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void release(String release) {
        this.release = release;
    }

    public void file(File file) {
        this.file = file;
    }

    @Override
    public void init() {
        super.init();
        this.titleLink.onExecute(e -> DisplayHelper.uiFile(this.filename(), this.file));
    }

    public void refresh() {
        super.refresh();
        String extension = FilenameUtils.getExtension((String)this.file.getName());
        this.titleLink.title(this.file.getName().replace("." + extension, ""));
    }

    private String filename() {
        String extension = FilenameUtils.getExtension((String)this.file.getName());
        return this.language.name() + "-" + this.file.getName().replace("." + extension, "") + "-" + this.release + "." + extension;
    }
}

