/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.languages;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.AlexandriaWebSocket;
import io.intino.ls.IntinoLanguageServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class LanguageServerWebSocketHandler
implements AlexandriaWebSocket {
    public static final int MessageSize = 1000000;
    private final Function<Session, LanguageServer> provider;
    private final Map<Session, ExecutorService> executorServiceMap = new HashMap<Session, ExecutorService>();
    private final Map<Session, PipedOutputStream> clientOutputMap = new HashMap<Session, PipedOutputStream>();
    private final Map<Session, PipedInputStream> serverInputMap = new HashMap<Session, PipedInputStream>();
    private final Object monitor = new Object();

    public LanguageServerWebSocketHandler(Function<Session, LanguageServer> provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketConnect(Session session) {
        try {
            Object object = this.monitor;
            synchronized (object) {
                session.setIdleTimeout(Duration.ofDays(1L));
                session.setMaxTextMessageSize(1000000L);
                PipedInputStream clientInput = new PipedInputStream(1000000);
                this.clientOutputMap.put(session, new PipedOutputStream(clientInput));
                this.serverInputMap.put(session, new PipedInputStream(1000000));
                PipedOutputStream out = new PipedOutputStream(this.serverInputMap.get(session));
                this.executorServiceMap.put(session, Executors.newSingleThreadExecutor());
                this.executorServiceMap.get(session).submit(() -> this.notificationThread(session));
                IntinoLanguageServer server = (IntinoLanguageServer)this.provider.apply(session);
                Launcher serverLauncher = LSPLauncher.createServerLauncher((LanguageServer)server, (InputStream)clientInput, (OutputStream)out);
                server.connect((LanguageClient)serverLauncher.getRemoteProxy());
                serverLauncher.startListening();
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public void onWebSocketText(Session session, String message) {
        try {
            String content = "Content-Length: " + message.getBytes().length + "\n\n" + message;
            this.clientOutputMap.get(session).write(content.getBytes());
            this.clientOutputMap.get(session).flush();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public void onWebSocketBinary(Session session, byte[] data, int offset, int length) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketError(Session session, Throwable error) {
        Object object = this.monitor;
        synchronized (object) {
            this.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketClose(Session session, int statusCode, String reason) {
        Object object = this.monitor;
        synchronized (object) {
            this.remove(session);
        }
    }

    private void remove(Session session) {
        if (this.executorServiceMap.containsKey(session)) {
            this.executorServiceMap.get(session).shutdown();
        }
        this.executorServiceMap.remove(session);
        this.clientOutputMap.remove(session);
        this.serverInputMap.remove(session);
    }

    private void notificationThread(Session session) {
        block7: {
            try {
                int bytesRead;
                if (!session.isOpen()) {
                    return;
                }
                if (!this.serverInputMap.containsKey(session)) {
                    return;
                }
                if (this.serverInputMap.get(session).available() < 0) {
                    return;
                }
                byte[] buffer = new byte[8096];
                while ((bytesRead = this.serverInputMap.get(session).read(buffer)) != -1) {
                    String content = new String(buffer, 0, bytesRead);
                    content = content.replaceAll("Content-Length: [0-9+]*", "").trim();
                    for (String message : content.split("\r?\n")) {
                        if (message.isEmpty()) continue;
                        session.getRemote().sendString(message.trim());
                    }
                }
            }
            catch (IOException e) {
                if (!session.isOpen()) break block7;
                Logger.error((Throwable)e);
            }
        }
    }
}

