/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.model;

import io.quassar.editor.model.Collection;
import io.quassar.editor.model.SubjectWrapper;
import java.time.Instant;
import java.time.ZoneId;
import systems.intino.datamarts.subjectstore.model.Subject;

public class License
extends SubjectWrapper {
    public License(Subject subject) {
        super(subject);
    }

    public String code() {
        return this.get("code");
    }

    public void code(String value) {
        this.set("code", value);
    }

    public String user() {
        return this.get("user");
    }

    public void user(String value) {
        this.set("user", value);
    }

    public Collection collection() {
        return new Collection(this.subject.parent());
    }

    public Status status() {
        return Status.valueOf(this.get("status"));
    }

    public void status(Status value) {
        this.set("status", value.name());
    }

    public int duration() {
        return Integer.parseInt(this.get("duration"));
    }

    public void duration(int value) {
        this.set("duration", String.valueOf(value));
    }

    public Instant createDate() {
        return Instant.parse(this.get("create-date"));
    }

    public void createDate(Instant createDate) {
        this.set("create-date", createDate.toString());
    }

    public Instant assignDate() {
        String value = this.get("assign-date");
        return value != null ? Instant.parse(value) : null;
    }

    public void assignDate(Instant value) {
        this.set("assign-date", value != null ? value.toString() : null);
    }

    public Instant expireDate() {
        if (this.assignDate() == null) {
            return null;
        }
        if (this.duration() == -1) {
            return null;
        }
        return this.assignDate().atZone(ZoneId.systemDefault()).plusMonths(this.duration()).toInstant();
    }

    public boolean isExpired() {
        Instant expireDate = this.expireDate();
        return expireDate == null || expireDate.isBefore(Instant.now());
    }

    public static enum Status {
        Created,
        Assigned;

    }
}

