/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractLicenseExpiredBanner;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.License;
import java.util.Set;

public class LicenseExpiredBanner
extends AbstractLicenseExpiredBanner<EditorBox> {
    private Language language;
    private String hint;

    public LicenseExpiredBanner(EditorBox box) {
        super(box);
    }

    public void language(GavCoordinates language) {
        this.language = ((EditorBox)this.box()).languageManager().get(language);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void hint(String value) {
        this.hint = value;
    }

    @Override
    public void init() {
        super.init();
        this.renewLicense.onExecute(e -> this.openRenewDialog());
        this.renewLicenseDialog.onRenew(e -> ((TemplateNotifier)this.notifier).redirect());
    }

    public void refresh() {
        super.refresh();
        this.content.visible(this.user() != null && !PermissionsHelper.hasValidLicense(this.language, this.session(), (EditorBox)this.box()));
        if (!this.content.isVisible()) {
            return;
        }
        License license = this.license();
        this.bullet.formats(Set.of(license == null || license.isExpired() ? "inactiveBullet" : "activeBullet"));
        this.title.value((String)(license != null ? license.code() + " - " + license.collection().name() : "License required"));
        this.expirationInfo.value(DisplayHelper.expirationInfo(license, arg_0 -> ((LicenseExpiredBanner)this).translate(arg_0), this.language()));
        this.expirationMessage.value(this.hint);
        this.renewLicense.visible(license != null);
    }

    private void openRenewDialog() {
        this.renewLicenseDialog.license(this.license());
        this.renewLicenseDialog.open();
    }

    private License license() {
        return ((EditorBox)this.box()).collectionManager().anyLicense(this.language.collection(), this.username());
    }
}

