/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.AddCollectionItemEvent;
import io.intino.alexandria.ui.model.Datasource;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.datasources.CollectionLanguagesDatasource;
import io.quassar.editor.box.ui.displays.items.LanguageCollectionItem;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguagesCollectionTemplate;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Collection;
import io.quassar.editor.model.Language;
import java.util.List;

public class LanguagesCollectionTemplate
extends AbstractLanguagesCollectionTemplate<EditorBox> {
    private Collection collection;

    public LanguagesCollectionTemplate(EditorBox box) {
        super(box);
    }

    public void collection(Collection collection) {
        this.collection = collection;
    }

    public void filter(String condition) {
        this.languagesCollectionCatalog.filter(condition);
    }

    public void filter(String grouping, List<String> values) {
        this.languagesCollectionCatalog.filter(grouping, values);
    }

    @Override
    public void init() {
        super.init();
        this.languagesCollectionCatalog.onAddItem(this::refresh);
        this.searchBox.onEnterPress(e -> this.filter((String)e.value()));
        this.searchBox.onChange(e -> this.filter((String)e.value()));
    }

    public void refresh() {
        super.refresh();
        this.refreshLanguages();
    }

    private void refreshLanguages() {
        CollectionLanguagesDatasource source = new CollectionLanguagesDatasource((EditorBox)this.box(), this.session(), this.collection);
        this.languagesCollectionCatalog.source((Datasource)source);
        this.noItemsMessage.visible(source.itemCount() == 0L);
        this.searchBox.visible(source.itemCount() > DisplayHelper.MinItemsCount * 4L);
    }

    private void refresh(AddCollectionItemEvent event) {
        Language language = (Language)event.item();
        LanguageCollectionItem item = (LanguageCollectionItem)event.component();
        item.logo.value(LanguageHelper.logo(language, (EditorBox)this.box()));
        item.logoLink.address(path -> PathHelper.languagePath(path, language));
        item.name.title(language.name());
        item.name.address(path -> PathHelper.languagePath(path, language));
    }
}

