/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.LanguageCommands;
import io.quassar.editor.box.ui.displays.AbstractHelpEditor;
import io.quassar.editor.box.ui.displays.notifiers.HelpEditorNotifier;
import io.quassar.editor.model.Language;

public class HelpEditor
extends AbstractHelpEditor<EditorBox> {
    private Language language;
    private String release;

    public HelpEditor(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void release(String release) {
        this.release = release;
    }

    public void update(String value) {
        ((EditorBox)this.box()).commands(LanguageCommands.class).saveHelp(this.language, this.release, value, this.username());
    }

    public void refresh() {
        super.refresh();
        if (this.language == null || this.release == null) {
            return;
        }
        ((HelpEditorNotifier)this.notifier).refresh(((EditorBox)this.box()).languageManager().loadHelp(this.language, this.release));
    }

    private String username() {
        return this.session() != null && this.session().user() != null ? this.session().user().username() : "anonymous";
    }
}

