/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.models.writers;

import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.models.FileWriter;
import io.quassar.editor.box.models.Workspace;
import io.quassar.editor.box.models.WorkspaceReader;
import io.quassar.editor.box.util.WorkspaceHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.lsp4j.CreateFilesParams;
import org.eclipse.lsp4j.DeleteFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.FileCreate;
import org.eclipse.lsp4j.FileDelete;
import org.eclipse.lsp4j.FileRename;
import org.eclipse.lsp4j.RenameFilesParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceFoldersChangeEvent;
import org.eclipse.lsp4j.services.LanguageServer;

public class ModelWriter
implements FileWriter {
    private final Workspace workspace;
    private final LanguageServer server;

    public ModelWriter(Workspace workspace, LanguageServer server) {
        this.workspace = workspace;
        this.server = server;
    }

    @Override
    public File copy(String filename, File source) {
        String parent = WorkspaceHelper.parent(source.uri());
        String uri = (String)(!parent.isEmpty() ? parent + java.io.File.separator : "") + filename;
        String content = this.content(source.uri());
        this.server.getWorkspaceService().didCreateFiles(new CreateFilesParams(List.of(new FileCreate(uri))));
        this.server.getTextDocumentService().didSave(new DidSaveTextDocumentParams(new TextDocumentIdentifier(uri), content));
        return new File(filename, uri, source.isDirectory(), new ArrayList<String>());
    }

    @Override
    public File create(String filename, InputStream content, File parent) {
        String uri = (String)(parent != null && parent.isDirectory() ? parent.uri() + java.io.File.separator : "") + filename;
        this.server.getWorkspaceService().didCreateFiles(new CreateFilesParams(List.of(new FileCreate(uri))));
        if (content != null) {
            this.server.getTextDocumentService().didSave(new DidSaveTextDocumentParams(new TextDocumentIdentifier(uri), this.toString(content)));
        }
        return new File(filename, uri, false, new ArrayList<String>());
    }

    @Override
    public File createFolder(String name, File parent) {
        String uri = (String)(parent != null && parent.isDirectory() ? parent.uri() + java.io.File.separator : "") + name;
        DidChangeWorkspaceFoldersParams params = new DidChangeWorkspaceFoldersParams(new WorkspaceFoldersChangeEvent(List.of(new WorkspaceFolder(uri, name)), Collections.emptyList()));
        this.server.getWorkspaceService().didChangeWorkspaceFolders(params);
        return new File(name, uri, true, new ArrayList<String>());
    }

    @Override
    public void save(File file, InputStream content) {
        this.server.getTextDocumentService().didSave(new DidSaveTextDocumentParams(new TextDocumentIdentifier(file.uri()), this.toString(content)));
    }

    @Override
    public File rename(File file, String newName) {
        String parent = WorkspaceHelper.parent(file.uri());
        String newUri = (String)(!parent.isEmpty() ? parent + java.io.File.separator : "") + newName;
        this.server.getWorkspaceService().didRenameFiles(new RenameFilesParams(List.of(new FileRename(file.uri(), newUri))));
        return new File(newName, newUri, file.isDirectory(), file.parents());
    }

    @Override
    public File move(File file, File directory) {
        String newUri = (String)(directory != null ? directory.uri() + java.io.File.separator : "") + file.name();
        this.server.getWorkspaceService().didRenameFiles(new RenameFilesParams(List.of(new FileRename(file.uri(), newUri))));
        return new File(file.name(), newUri, file.isDirectory(), new ArrayList<String>());
    }

    @Override
    public void remove(File file) {
        if (file.isDirectory()) {
            DidChangeWorkspaceFoldersParams params = new DidChangeWorkspaceFoldersParams(new WorkspaceFoldersChangeEvent(Collections.emptyList(), List.of(new WorkspaceFolder(file.uri(), file.name()))));
            this.server.getWorkspaceService().didChangeWorkspaceFolders(params);
        } else {
            DeleteFilesParams params = new DeleteFilesParams(List.of(new FileDelete(file.uri())));
            this.server.getWorkspaceService().didDeleteFiles(params);
        }
    }

    private String content(String uri) {
        try {
            InputStream content = new WorkspaceReader(this.workspace, this.server).content(uri);
            return content != null ? IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8) : "";
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return "";
        }
    }

    private String toString(InputStream content) {
        try {
            return IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ignored) {
            return null;
        }
    }
}

