/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands.model;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.language.RemoveLanguageCommand;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;

public class RemoveModelCommand
extends Command<Boolean> {
    public Model model;

    public RemoveModelCommand(EditorBox box) {
        super(box);
    }

    @Override
    public Boolean execute() {
        Language language = this.box.languageManager().get(this.model);
        if (language != null && ModelHelper.isMetamodel(this.model, this.box)) {
            this.removeLanguage(language);
        }
        this.unlinkModel();
        this.removeModel();
        return true;
    }

    private void removeLanguage(Language language) {
        RemoveLanguageCommand command = new RemoveLanguageCommand(this.box);
        command.author = this.author;
        command.language = language;
        command.execute();
    }

    private void unlinkModel() {
        if (!this.model.isExample()) {
            return;
        }
        Language language = this.box.languageManager().get(this.model);
        LanguageRelease release = language.release(this.model.language().version());
        if (release == null) {
            return;
        }
        release.removeExample(this.model.id());
    }

    private void removeModel() {
        this.box.modelManager().remove(this.model);
    }
}

