/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands.model;

import io.intino.builderservice.schemas.Message;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.model.Model;
import java.util.List;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;

public class CheckModelCommand
extends Command<Command.CommandResult> {
    public Model model;
    public String release;

    public CheckModelCommand(EditorBox box) {
        super(box);
    }

    @Override
    public Command.CommandResult execute() {
        Command.CommandResult result = this.resultOf(this.box.modelManager().check(this.model, this.release));
        if (result.success() && !this.box.modelManager().hasWorkspaceMograms(this.model, this.release)) {
            return this.noMogramsResult();
        }
        return result;
    }

    private Command.CommandResult resultOf(List<Diagnostic> diagnosticList) {
        final List<Message> messages = diagnosticList.stream().map(this::messageOf).toList();
        return new Command.CommandResult(){

            @Override
            public boolean success() {
                return messages.stream().noneMatch(m -> m.kind() == Message.Kind.ERROR);
            }

            @Override
            public List<Message> messages() {
                return messages;
            }
        };
    }

    private Message messageOf(Diagnostic diagnostic) {
        Position start = diagnostic.getRange().getStart();
        return new Message().uri(diagnostic.getSource()).kind(this.kindOf(diagnostic.getSeverity())).content(diagnostic.getMessage()).column(start.getCharacter()).line(start.getLine());
    }

    private Message.Kind kindOf(DiagnosticSeverity severity) {
        return switch (severity) {
            default -> throw new MatchException(null, null);
            case DiagnosticSeverity.Hint, DiagnosticSeverity.Information -> Message.Kind.INFO;
            case DiagnosticSeverity.Warning -> Message.Kind.WARNING;
            case DiagnosticSeverity.Error -> Message.Kind.ERROR;
        };
    }

    private Command.CommandResult noMogramsResult() {
        return new Command.CommandResult(this){

            @Override
            public boolean success() {
                return false;
            }

            @Override
            public List<Message> messages() {
                return List.of(new Message().kind(Message.Kind.ERROR).content("Could not check. Model is empty"));
            }
        };
    }
}

