/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.Commands;
import io.quassar.editor.box.commands.model.AddModelZipCommand;
import io.quassar.editor.box.commands.model.CheckModelCommand;
import io.quassar.editor.box.commands.model.CloneModelCommand;
import io.quassar.editor.box.commands.model.CopyModelFileCommand;
import io.quassar.editor.box.commands.model.CreateExampleModelCommand;
import io.quassar.editor.box.commands.model.CreateModelCommand;
import io.quassar.editor.box.commands.model.CreateModelFileCommand;
import io.quassar.editor.box.commands.model.CreateModelFolderCommand;
import io.quassar.editor.box.commands.model.CreateModelReleaseCommand;
import io.quassar.editor.box.commands.model.MakeModelPrivateCommand;
import io.quassar.editor.box.commands.model.MakeModelPublicCommand;
import io.quassar.editor.box.commands.model.MoveModelFileCommand;
import io.quassar.editor.box.commands.model.RemoveModelCommand;
import io.quassar.editor.box.commands.model.RemoveModelFileCommand;
import io.quassar.editor.box.commands.model.RenameModelFileCommand;
import io.quassar.editor.box.commands.model.SaveModelCollaboratorsCommand;
import io.quassar.editor.box.commands.model.SaveModelDescriptionCommand;
import io.quassar.editor.box.commands.model.SaveModelFileCommand;
import io.quassar.editor.box.commands.model.SaveModelQualifiedTitleCommand;
import io.quassar.editor.box.commands.model.SaveModelSimpleTitleCommand;
import io.quassar.editor.box.commands.model.UpdateModelLanguageVersionCommand;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.ui.types.ModelView;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.io.InputStream;
import java.util.List;

public class ModelCommands
extends Commands {
    public ModelCommands(EditorBox box) {
        super(box);
    }

    public Model create(String name, String title, String description, GavCoordinates language, String owner, String username) {
        CreateModelCommand command = this.setup(new CreateModelCommand(this.box), username);
        command.name = name;
        command.title = title;
        command.description = description;
        command.language = language;
        command.owner = owner;
        return command.execute();
    }

    public Model createTemplate(Language language, LanguageRelease release, String username) {
        CreateModelCommand command = this.setup(new CreateModelCommand(this.box), username);
        command.language = GavCoordinates.fromString(language, release);
        command.name = ModelHelper.proposeName();
        command.title = language.name();
        command.description = "";
        command.usage = Model.Usage.Template;
        return command.execute();
    }

    public Model createExample(Language language, LanguageRelease release, String username) {
        CreateExampleModelCommand command = this.setup(new CreateExampleModelCommand(this.box), username);
        command.language = language;
        command.release = release;
        return command.execute();
    }

    public Model clone(Model model, String release, String name, String username) {
        CloneModelCommand command = this.setup(new CloneModelCommand(this.box), username);
        command.model = model;
        command.release = release;
        command.name = name;
        return command.execute();
    }

    public Boolean addZip(Model model, ModelView view, InputStream content, File parent, String username) {
        AddModelZipCommand command = this.setup(new AddModelZipCommand(this.box), username);
        command.model = model;
        command.view = view;
        command.content = content;
        command.parent = parent;
        return command.execute();
    }

    public File createFile(Model model, String name, InputStream content, File parent, String username) {
        CreateModelFileCommand command = this.setup(new CreateModelFileCommand(this.box), username);
        command.model = model;
        command.name = name;
        command.content = content;
        command.parent = parent;
        return command.execute();
    }

    public File createFolder(Model model, String name, File parent, String username) {
        CreateModelFolderCommand command = this.setup(new CreateModelFolderCommand(this.box), username);
        command.model = model;
        command.name = name;
        command.parent = parent;
        return command.execute();
    }

    public File copy(Model model, String filename, File source, String username) {
        CopyModelFileCommand command = this.setup(new CopyModelFileCommand(this.box), username);
        command.model = model;
        command.filename = filename;
        command.source = source;
        return command.execute();
    }

    public void saveDescription(Model model, String description, String username) {
        SaveModelDescriptionCommand command = this.setup(new SaveModelDescriptionCommand(this.box), username);
        command.model = model;
        command.description = description;
        command.execute();
    }

    public void saveSimpleTitle(Model model, String title, String username) {
        SaveModelSimpleTitleCommand command = this.setup(new SaveModelSimpleTitleCommand(this.box), username);
        command.model = model;
        command.title = title;
        command.execute();
    }

    public void saveQualifiedTitle(Model model, String project, String module, String username) {
        SaveModelQualifiedTitleCommand command = this.setup(new SaveModelQualifiedTitleCommand(this.box), username);
        command.model = model;
        command.project = project;
        command.module = module;
        command.execute();
    }

    public void save(Model model, List<String> collaborators, String username) {
        SaveModelCollaboratorsCommand command = this.setup(new SaveModelCollaboratorsCommand(this.box), username);
        command.model = model;
        command.collaborators = collaborators;
        command.execute();
    }

    public void save(Model model, File file, InputStream content, String username) {
        SaveModelFileCommand command = this.setup(new SaveModelFileCommand(this.box), username);
        command.model = model;
        command.file = file;
        command.content = content;
        command.execute();
    }

    public File rename(Model model, String newName, File file, String username) {
        RenameModelFileCommand command = this.setup(new RenameModelFileCommand(this.box), username);
        command.model = model;
        command.file = file;
        command.newName = newName;
        return command.execute();
    }

    public File move(Model model, File file, File directory, String username) {
        MoveModelFileCommand command = this.setup(new MoveModelFileCommand(this.box), username);
        command.model = model;
        command.file = file;
        command.directory = directory;
        return command.execute();
    }

    public void makePrivate(Model model, String username) {
        MakeModelPrivateCommand command = this.setup(new MakeModelPrivateCommand(this.box), username);
        command.model = model;
        command.execute();
    }

    public void makePublic(Model model, String username) {
        MakeModelPublicCommand command = this.setup(new MakeModelPublicCommand(this.box), username);
        command.model = model;
        command.execute();
    }

    public void updateLanguageVersion(Model model, String version, String username) {
        UpdateModelLanguageVersionCommand command = this.setup(new UpdateModelLanguageVersionCommand(this.box), username);
        command.model = model;
        command.version = version;
        command.execute();
    }

    public void remove(Model model, String username) {
        RemoveModelCommand command = this.setup(new RemoveModelCommand(this.box), username);
        command.model = model;
        command.execute();
    }

    public void remove(Model model, File file, String username) {
        RemoveModelFileCommand command = this.setup(new RemoveModelFileCommand(this.box), username);
        command.model = model;
        command.file = file;
        command.execute();
    }

    public Command.CommandResult check(Model model, String username) {
        CheckModelCommand command = this.setup(new CheckModelCommand(this.box), username);
        command.model = model;
        command.release = "draft";
        return command.execute();
    }

    public Command.CommandResult createRelease(Model model, String version, String username) {
        CreateModelReleaseCommand command = this.setup(new CreateModelReleaseCommand(this.box), username);
        command.model = model;
        command.version = version;
        return command.execute();
    }
}

