/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Commands;
import io.quassar.editor.box.commands.collection.AddLicenseCommand;
import io.quassar.editor.box.commands.collection.AddLicensesCommand;
import io.quassar.editor.box.commands.collection.AssignLicenseCommand;
import io.quassar.editor.box.commands.collection.CreateCollectionCommand;
import io.quassar.editor.box.commands.collection.RemoveCollectionCommand;
import io.quassar.editor.box.commands.collection.RenewLicenseCommand;
import io.quassar.editor.box.commands.collection.RevokeLicenseCommand;
import io.quassar.editor.box.commands.collection.SaveCollectionCollaboratorsCommand;
import io.quassar.editor.model.Collection;
import io.quassar.editor.model.License;
import java.util.List;

public class CollectionCommands
extends Commands {
    public CollectionCommands(EditorBox box) {
        super(box);
    }

    public Collection create(String name, Collection.SubscriptionPlan plan, String username) {
        CreateCollectionCommand command = this.setup(new CreateCollectionCommand(this.box), username);
        command.name = name;
        command.plan = plan;
        return command.execute();
    }

    public List<License> addLicenses(Collection collection, double count, double duration, String username) {
        AddLicensesCommand command = this.setup(new AddLicensesCommand(this.box), username);
        command.collection = collection;
        command.count = Double.valueOf(count).intValue();
        command.duration = Double.valueOf(duration).intValue();
        return command.execute();
    }

    public License addLicense(Collection collection, int duration, String username) {
        AddLicenseCommand command = this.setup(new AddLicenseCommand(this.box), username);
        command.collection = collection;
        command.duration = Double.valueOf(duration).intValue();
        return command.execute();
    }

    public boolean revokeLicense(Collection collection, License license, String username) {
        RevokeLicenseCommand command = this.setup(new RevokeLicenseCommand(this.box), username);
        command.collection = collection;
        command.license = license;
        return command.execute();
    }

    public AssignLicenseCommand.AssignResult assignLicense(String license, String username) {
        AssignLicenseCommand command = this.setup(new AssignLicenseCommand(this.box), username);
        command.license = license;
        return command.execute();
    }

    public RenewLicenseCommand.RenewResult renew(License license, int duration, String username) {
        RenewLicenseCommand command = this.setup(new RenewLicenseCommand(this.box), username);
        command.license = license;
        command.duration = duration;
        return command.execute();
    }

    public void save(Collection collection, List<String> collaborators, String username) {
        SaveCollectionCollaboratorsCommand command = this.setup(new SaveCollectionCollaboratorsCommand(this.box), username);
        command.collection = collection;
        command.collaborators = collaborators;
        command.execute();
    }

    public boolean remove(Collection collection, String username) {
        RemoveCollectionCommand command = this.setup(new RemoveCollectionCommand(this.box), username);
        command.collection = collection;
        return command.execute();
    }
}

