/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.util;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.components.TextEditable;
import io.intino.alexandria.ui.server.UIFile;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.alexandria.ui.services.push.User;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.util.Formatters;
import io.quassar.editor.box.util.NameHelper;
import io.quassar.editor.model.License;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.function.Function;

public class DisplayHelper {
    public static long MinItemsCount = 5L;

    public static String valueOrDefault(String value) {
        return value != null && !value.isEmpty() ? value : "-";
    }

    public static String user(UISession session) {
        User user = session.user();
        return user != null ? user.username() : "anonymous";
    }

    public static boolean check(TextEditable<?, ?> field, Function<String, String> translator) {
        field.error(null);
        if (field.value() == null || field.value().isEmpty()) {
            field.error(translator.apply("Field required"));
            return false;
        }
        return true;
    }

    public static CheckResult checkCollectionName(String name, Function<String, String> translator, EditorBox box) {
        if (name == null || name.isEmpty()) {
            return new CheckResult(false, translator.apply("Collection name is required"));
        }
        if (!NameHelper.validName(name)) {
            return new CheckResult(false, translator.apply("Collection name contains non alphanumeric characters"));
        }
        if (NameHelper.reservedCollectionName(name)) {
            return new CheckResult(false, translator.apply("Collection name is reserved and cannot be used"));
        }
        if (NameHelper.collectionInUse(name, box)) {
            return new CheckResult(false, translator.apply("Collection is already registered. You need to be invited as author in this collection"));
        }
        return new CheckResult(true, null);
    }

    public static CheckResult checkLanguageName(String name, Function<String, String> translator) {
        if (name == null || name.isEmpty()) {
            return new CheckResult(false, translator.apply("Name is required"));
        }
        if (!NameHelper.validName(name)) {
            return new CheckResult(false, translator.apply("Name contains non alphanumeric characters"));
        }
        if (NameHelper.reservedName(name)) {
            return new CheckResult(false, translator.apply("This name is reserved and cannot be used"));
        }
        return new CheckResult(true, null);
    }

    public static CheckResult checkLanguageInUse(String collection, String name, Function<String, String> translator, EditorBox box) {
        if (NameHelper.languageInUse(collection, name, box)) {
            return new CheckResult(false, translator.apply("A DSL with this name already exists in the selected collection"));
        }
        return new CheckResult(true, null);
    }

    public static Resource emptyFile() {
        return new Resource("empty", (InputStream)new ByteArrayInputStream(new byte[0]));
    }

    public static UIFile uiFile(String label, File content) {
        try {
            if (!content.exists()) {
                return DisplayHelper.uiFile(label, new ByteArrayInputStream(new byte[0]));
            }
            return DisplayHelper.uiFile(label, new FileInputStream(content));
        }
        catch (FileNotFoundException e) {
            Logger.error((Throwable)e);
            return DisplayHelper.uiFile(label, new ByteArrayInputStream(new byte[0]));
        }
    }

    public static UIFile uiFile(final String label, final InputStream content) {
        return new UIFile(){

            public String label() {
                return label;
            }

            public InputStream content() {
                return content;
            }
        };
    }

    public static String expirationInfo(License license, Function<String, String> translator, String language) {
        if (license == null) {
            return translator.apply("a valid license is required");
        }
        if (license.expireDate() == null) {
            return translator.apply("perpetual license");
        }
        if (license.isExpired()) {
            return translator.apply("expired since %s").formatted(Formatters.date(license.expireDate(), language, translator));
        }
        return translator.apply("valid until %s").formatted(Formatters.date(license.expireDate(), language, translator));
    }

    public record CheckResult(boolean success, String message) {
    }
}

