/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractProjectViewer;
import io.quassar.editor.box.ui.displays.templates.ProjectModuleViewer;
import io.quassar.editor.model.Model;
import java.util.List;
import java.util.function.Consumer;

public class ProjectViewer
extends AbstractProjectViewer<EditorBox> {
    private Model model;
    private String project;
    private Consumer<Model> selectListener;

    public ProjectViewer(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void project(String project) {
        this.project = project;
    }

    public void onSelect(Consumer<Model> listener) {
        this.selectListener = listener;
    }

    public void refresh() {
        super.refresh();
        List<String> moduleList = ((EditorBox)this.box()).modelManager().modules(this.project, this.username());
        this.modules.clear();
        moduleList.forEach(p -> this.fill((String)p, (ProjectModuleViewer)this.modules.add()));
    }

    private void fill(String module, ProjectModuleViewer display) {
        display.model(this.model);
        display.onSelect(e -> this.selectListener.accept((Model)e));
        display.module(module);
        display.refresh();
    }
}

