/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.intino.alexandria.ui.services.push.User;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractHeaderTemplate;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;

public class HeaderTemplate
extends AbstractHeaderTemplate<EditorBox> {
    private Language language;
    private String release;
    private Model model;

    public HeaderTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language value) {
        this.language = value;
    }

    public void release(String release) {
        this.release = release;
    }

    public void model(Model value) {
        this.model = value;
    }

    @Override
    public void init() {
        super.init();
        this.login.onExecute(e -> {
            this.session().add("callback", this.session().browser().requestUrl());
            if (((EditorBox)this.box()).authService() == null) {
                ((TemplateNotifier)this.notifier).redirect(PathHelper.loginUrl(this.session()));
            } else {
                ((TemplateNotifier)this.notifier).redirect(this.session().login(this.session().browser().baseUrl()));
            }
        });
        this.user.onRefresh(e -> this.refreshUser());
        this.languageLink.onExecute(e -> ((TemplateNotifier)this.notifier).redirect(PathHelper.modelUrl(this.model, this.session())));
    }

    public void refresh() {
        super.refresh();
        User loggedUser = this.session().user();
        this.login.visible(loggedUser == null);
        this.user.visible(loggedUser != null);
        this.refreshLanguageBlock();
    }

    private void refreshLanguageBlock() {
        this.languageBlock.visible(this.language != null);
        if (!this.languageBlock.isVisible()) {
            return;
        }
        this.languageLink.title(LanguageHelper.label(this.language, arg_0 -> ((HeaderTemplate)this).translate(arg_0)));
        Model metamodel = !this.language.isFoundational() ? ((EditorBox)this.box()).modelManager().get(this.language.metamodel()) : null;
        this.languageLink.readonly(metamodel == null);
    }

    private void refreshUser() {
        this.userHomeStamp.refresh();
    }
}

