/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.model;

import io.quassar.editor.model.License;
import io.quassar.editor.model.SubjectWrapper;
import java.time.Instant;
import java.util.List;
import java.util.stream.Stream;
import systems.intino.datamarts.subjectstore.model.Subject;

public class Collection
extends SubjectWrapper {
    public Collection(Subject subject) {
        super(subject);
    }

    public String id() {
        return this.subject.name();
    }

    public String name() {
        return this.getOrEmpty("name");
    }

    public void name(String value) {
        this.set("name", value);
    }

    public String owner() {
        return Collection.owner(this.subject);
    }

    public static String owner(Subject subject) {
        return subject.get("owner");
    }

    public void owner(String owner) {
        this.set("owner", owner);
    }

    public Instant createDate() {
        String value = this.get("create-date");
        return value != null ? Instant.parse(value) : null;
    }

    public void createDate(Instant date) {
        this.set("create-date", date.toString());
    }

    public Instant updateDate() {
        String value = this.get("update-date");
        return value != null ? Instant.parse(value) : null;
    }

    public void updateDate(Instant date) {
        this.set("update-date", date.toString());
    }

    public List<String> collaborators() {
        return this.getList("collaborator");
    }

    public void collaborators(List<String> values) {
        this.putList("collaborator", values);
    }

    public void add(String collaborator) {
        this.put("collaborator", collaborator);
    }

    public SubscriptionPlan subscriptionPlan() {
        String name = this.get("subscription-plan");
        return name != null ? SubscriptionPlan.valueOf(name) : SubscriptionPlan.Professional;
    }

    public void subscriptionPlan(SubscriptionPlan value) {
        this.set("subscription-plan", value.name());
    }

    public List<License> licenses() {
        Stream<Subject> result = this.subject.children().collect().stream().filter(s -> s.is("license"));
        return result.map(this::licenseOf).toList();
    }

    public List<License> licenses(String username) {
        Stream<Subject> result = this.subject.children().collect().stream().filter(s -> s.is("license"));
        return result.map(this::licenseOf).filter(l -> username.equals(l.user())).toList();
    }

    public License license(String code) {
        return this.licenses().stream().filter(r -> r.code().equals(code)).findFirst().orElse(null);
    }

    public License anyLicense(String username) {
        return this.licenses().stream().filter(r -> username.equals(r.user())).findFirst().orElse(null);
    }

    public List<License> validLicenses() {
        return this.licenses().stream().filter(r -> !r.isExpired()).toList();
    }

    public License validLicense(String username) {
        return this.licenses().stream().filter(r -> username.equals(r.user()) && !r.isExpired()).findFirst().orElse(null);
    }

    private License licenseOf(Subject subject) {
        return new License(subject);
    }

    public static enum SubscriptionPlan {
        Professional,
        Enterprise;

    }
}

