/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractUserHomeTemplate;
import io.quassar.editor.box.ui.displays.templates.CollectionItemTemplate;
import io.quassar.editor.box.ui.displays.templates.LicenseItemTemplate;
import io.quassar.editor.model.Collection;
import io.quassar.editor.model.License;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UserHomeTemplate
extends AbstractUserHomeTemplate<EditorBox> {
    public UserHomeTemplate(EditorBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.addLicenseEditor.onAdd(e -> this.refreshLicenses());
        this.renewLicenseDialog.onRenew(e -> this.refreshLicenses());
    }

    public void refresh() {
        super.refresh();
        this.refreshLicenses();
        this.refreshCollections();
    }

    private void refreshLicenses() {
        this.licenses.clear();
        Map<String, List<License>> licenseMap = ((EditorBox)this.box()).collectionManager().anyLicenses(this.username()).stream().collect(Collectors.groupingBy(l -> l.collection().name()));
        List<License> licenseList = licenseMap.values().stream().map(l -> l.stream().filter(l1 -> !l1.isExpired()).findFirst().orElse((License)l.getFirst())).toList();
        licenseList.forEach(l -> this.fill((License)l, (LicenseItemTemplate)this.licenses.add()));
    }

    private void refreshCollections() {
        List<Collection> collectionList = ((EditorBox)this.box()).collectionManager().collections(this.username());
        this.myCollectionsBlock.visible(!collectionList.isEmpty());
        if (!this.myCollectionsBlock.isVisible()) {
            return;
        }
        this.collections.clear();
        collectionList.forEach(c -> this.fill((Collection)c, (CollectionItemTemplate)this.collections.add()));
    }

    private void fill(License license, LicenseItemTemplate display) {
        display.license(license);
        display.onRenew(this::openRenewDialog);
        display.refresh();
    }

    private void fill(Collection collection, CollectionItemTemplate display) {
        display.collection(collection);
        display.refresh();
    }

    private void openRenewDialog(License license) {
        this.renewLicenseDialog.license(license);
        this.renewLicenseDialog.open();
    }
}

