/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.models.ModelContainer;
import io.quassar.editor.box.ui.displays.templates.AbstractModelTemplate;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.ui.types.ModelView;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.FilePosition;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Model;
import java.util.Comparator;
import java.util.List;

public class ModelTemplate
extends AbstractModelTemplate<EditorBox> {
    private Model model;
    private String release;
    private ModelView selectedView;
    private LanguageTab selectedTab;
    private ModelContainer modelContainer;
    private File selectedFile;
    private FilePosition selectedPosition;
    private boolean showHelp = false;
    private boolean isLanguageChangeBlockVisible = false;

    public ModelTemplate(EditorBox box) {
        super(box);
    }

    public void languageChanged(GavCoordinates language) {
        if (this.model == null) {
            return;
        }
        if (!this.model.language().equals(language)) {
            return;
        }
        if (this.isLanguageChangeBlockVisible) {
            return;
        }
        this.languageChangedBlock.show();
        this.isLanguageChangeBlockVisible = true;
    }

    public void openStarting(String model) {
        this.open(model, null, null, null, null, null, true);
    }

    public void openTemplate(String model) {
        this.open(model, "draft", null, null, null, null, false);
    }

    public void open(String model, String release) {
        this.open(model, release, null, null, null, null, false);
    }

    public void open(String model, String release, String tab, String view, String file, String position) {
        this.open(model, release, tab, view, file, position, false);
    }

    public void open(String model, String release, String tab, String view, String file, String position, boolean showHelp) {
        this.model = ((EditorBox)this.box()).modelManager().get(model);
        this.release = release != null ? release : "draft";
        this.selectedTab = tab != null ? LanguageTab.from(tab) : LanguageTab.About;
        this.selectedView = view != null ? ModelView.from(view) : ModelView.Model;
        this.modelContainer = this.model != null ? ((EditorBox)this.box()).modelManager().modelContainer(this.model, this.release) : null;
        this.selectedFile = file != null && this.modelContainer != null ? this.modelContainer.file(file) : null;
        this.selectedPosition = position != null ? FilePosition.from(position) : null;
        this.showHelp = showHelp;
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.reload.onExecute(e -> ((TemplateNotifier)this.notifier).redirect());
    }

    public void refresh() {
        super.refresh();
        this.notFoundBlock.visible(!PermissionsHelper.hasPermissions(this.model, this.session(), (EditorBox)this.box()));
        this.refreshContent();
    }

    private void refreshContent() {
        this.contentBlock.visible(PermissionsHelper.hasPermissions(this.model, this.session(), (EditorBox)this.box()));
        if (!this.contentBlock.isVisible()) {
            return;
        }
        this.modelEditor.model(this.model, this.release);
        this.modelEditor.view(this.view());
        this.modelEditor.tab(this.selectedTab);
        this.modelEditor.file(this.file(), this.selectedPosition);
        this.modelEditor.showHelp(this.showHelp);
        this.modelEditor.refresh();
    }

    private ModelView view() {
        return this.selectedView;
    }

    private File file() {
        if (this.selectedFile != null && this.modelContainer.exists(this.selectedFile)) {
            return this.selectedFile;
        }
        if (this.modelContainer == null) {
            return null;
        }
        List<File> files = this.selectedView == null || this.selectedView == ModelView.Model ? this.modelContainer.modelFiles().stream().sorted(Comparator.comparing(File::name)).toList() : this.modelContainer.resourceFiles().stream().filter(f -> !f.uri().equals("resources")).sorted(Comparator.comparing(File::name)).toList();
        return !files.isEmpty() ? files.getFirst() : null;
    }
}

