/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands.language;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.exceptions.NotFound;
import io.intino.alexandria.logger.Logger;
import io.intino.builderservice.schemas.Message;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.builder.BuildResult;
import io.quassar.editor.box.builder.ModelBuilder;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.model.CreateModelCommand;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.ShortIdGenerator;
import io.quassar.editor.box.util.TarHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;

public class CreateLanguageReleaseCommand
extends Command<Command.CommandResult> {
    public Language language;
    public String version;

    public CreateLanguageReleaseCommand(EditorBox box) {
        super(box);
    }

    @Override
    public Command.CommandResult execute() {
        BuildResult result = this.build(this.box.modelManager().get(this.language.metamodel()));
        if (!result.success()) {
            return this.resultOf(result);
        }
        LanguageRelease previousRelease = this.language.lastRelease();
        LanguageRelease release = this.box.languageManager().createRelease(this.language, this.version);
        this.createHelp(this.language, release, previousRelease);
        this.copyExamples(this.language, release, previousRelease);
        Model template = this.createTemplate(this.language, release, previousRelease);
        release.template(template.id());
        return this.resultOf(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BuildResult build(Model metamodel) {
        File destination = null;
        try {
            BuildResult result = new ModelBuilder(metamodel, new GavCoordinates(this.language.group(), this.language.name(), this.version), this.box).build(this.author);
            if (!result.success()) {
                BuildResult buildResult = result;
                return buildResult;
            }
            Resource resource = result.zipArtifacts();
            destination = this.box.archetype().tmp().builds(UUID.randomUUID().toString());
            TarHelper.extract(resource.inputStream(), destination);
            this.box.languageManager().saveDsl(this.language, this.version, LanguageHelper.dslOf(destination));
            this.box.languageManager().saveDslManifest(this.language, this.version, LanguageHelper.dslManifestOf(destination));
            this.box.languageManager().saveGraph(this.language, this.version, LanguageHelper.graphOf(destination));
            this.box.languageManager().saveParsers(this.language, this.version, LanguageHelper.parsersOf(destination));
            BuildResult buildResult = result;
            return buildResult;
        }
        catch (InternalServerError | NotFound | Exception e) {
            Logger.error((Throwable)e);
            BuildResult buildResult = BuildResult.failure(List.of(new Message().content(e.getMessage()).kind(Message.Kind.ERROR)));
            return buildResult;
        }
        finally {
            if (destination != null) {
                destination.delete();
            }
        }
    }

    private void createHelp(Language language, LanguageRelease release, LanguageRelease previousRelease) {
        if (previousRelease != null) {
            this.box.languageManager().saveHelp(language, release.version(), this.box.languageManager().loadHelp(language, previousRelease.version()));
        } else {
            this.createDefaultHelp(language, release);
        }
    }

    private void createDefaultHelp(Language language, LanguageRelease release) {
        try {
            InputStream stream = CreateModelCommand.class.getResourceAsStream("/templates/language.help.template.html");
            String content = stream != null ? IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8) : "";
            content = content.replace("$DSL$", language.name() + " " + release.version());
            this.box.languageManager().saveHelp(language, release.version(), content);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void copyExamples(Language language, LanguageRelease release, LanguageRelease previousRelease) {
        if (previousRelease == null) {
            return;
        }
        previousRelease.examples().forEach(e -> this.copyExample(language, release, (String)e));
    }

    private void copyExample(Language language, LanguageRelease release, String example) {
        Model model = this.box.modelManager().get(example);
        Model copy = this.box.modelManager().clone(model, "draft", ShortIdGenerator.generate(), model.name(), this.author);
        copy.language(GavCoordinates.fromString(language, release));
        copy.title(model.title());
        copy.usage(Model.Usage.Example);
        release.addExample(copy.id());
    }

    private Model createTemplate(Language language, LanguageRelease release, LanguageRelease previousRelease) {
        return previousRelease != null ? this.copyTemplate(language, release, previousRelease) : this.createEmptyTemplate(language, release);
    }

    private Model copyTemplate(Language language, LanguageRelease release, LanguageRelease previousRelease) {
        Model model = this.box.modelManager().getTemplate(language, previousRelease);
        Model clone = this.box.modelManager().clone(model, "draft", ShortIdGenerator.generate(), ModelHelper.proposeName(), this.author);
        clone.language(GavCoordinates.fromString(language, release));
        clone.title(language.name());
        clone.usage(Model.Usage.Template);
        return clone;
    }

    private Model createEmptyTemplate(Language language, LanguageRelease release) {
        CreateModelCommand command = new CreateModelCommand(this.box);
        command.author = this.author;
        command.language = GavCoordinates.fromString(language, release);
        command.name = ModelHelper.proposeName();
        command.title = language.name();
        command.description = "";
        command.usage = Model.Usage.Template;
        command.owner = this.author;
        return command.execute();
    }
}

