/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.LanguageCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageInfoTemplate;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageProperty;
import io.quassar.editor.model.Visibility;
import java.util.Arrays;
import java.util.List;

public class LanguageInfoTemplate
extends AbstractLanguageInfoTemplate<EditorBox> {
    private Language language;
    private String release;

    public LanguageInfoTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void release(String release) {
        this.release = release;
    }

    @Override
    public void init() {
        super.init();
        this.generalBlock.onInit(e -> this.initGeneralBlock());
        this.generalBlock.onShow(e -> this.refreshGeneralBlock());
        this.visibilityBlock.onInit(e -> this.initVisibilityBlock());
        this.visibilityBlock.onShow(e -> this.refreshVisibilityBlock());
    }

    public void refresh() {
        super.refresh();
        this.refreshView();
    }

    private void initGeneralBlock() {
        this.editorStamp.onChangeId(this::rename);
        this.editorStamp.onChangeLogo(e -> this.save(LanguageProperty.Logo, e));
    }

    private void refreshGeneralBlock() {
        this.editorStamp.language(this.language);
        this.editorStamp.refresh();
        this.refreshProperties();
    }

    private void initVisibilityBlock() {
        this.grantAccessField.onChange(e -> this.save(LanguageProperty.GrantAccess, this.grantAccessList()));
        this.licenseField.onChange(e -> this.save(LanguageProperty.License, this.licenseField.value()));
        this.visibilitySelector.onSelect(this::updateVisibility);
    }

    private void refreshVisibilityBlock() {
        this.visibilitySelector.selection(new String[]{this.language.isPrivate() ? "privateVisibilityOption" : "publicVisibilityOption"});
        this.visibilityBlock.publicVisibilityBlock.visible(this.language.isPublic());
        this.grantAccessField.value(String.join((CharSequence)"\n", this.language.grantAccessList()));
        this.licenseField.value(this.language.license());
    }

    private void refreshView() {
        this.hideViews();
        this.viewSelector.select(0);
    }

    private void hideViews() {
        if (this.generalBlock.isVisible()) {
            this.generalBlock.hide();
        } else if (this.visibilityBlock.isVisible()) {
            this.visibilityBlock.hide();
        }
    }

    private void refreshProperties() {
        this.propertiesStamp.language(this.language);
        this.propertiesStamp.release(this.release);
        this.propertiesStamp.refresh();
    }

    private List<String> grantAccessList() {
        return Arrays.stream(this.grantAccessField.value().split(";?\\n")).map(String::trim).filter(s -> !s.isEmpty()).toList();
    }

    private void rename(String newName) {
        ((EditorBox)this.box()).commands(LanguageCommands.class).rename(this.language, newName, this.username());
    }

    private void save(LanguageProperty property, Object value) {
        ((EditorBox)this.box()).commands(LanguageCommands.class).save(this.language, property, value, this.username());
    }

    private void updateVisibility(SelectionEvent event) {
        List selection = event.selection();
        boolean isPrivate = selection.isEmpty() || ((String)selection.getFirst()).equals("privateVisibilityOption");
        ((EditorBox)this.box()).commands(LanguageCommands.class).save(this.language, LanguageProperty.Visibility, (Object)(isPrivate ? Visibility.Private : Visibility.Public), this.username());
        this.refreshVisibilityBlock();
    }
}

