/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.util;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.components.TextEditable;
import io.intino.alexandria.ui.server.UIFile;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.alexandria.ui.services.push.User;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.util.NameHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.function.Function;

public class DisplayHelper {
    public static long MinItemsCount = 5L;

    public static String valueOrDefault(String value) {
        return value != null && !value.isEmpty() ? value : "-";
    }

    public static String user(UISession session) {
        User user = session.user();
        return user != null ? user.username() : "anonymous";
    }

    public static boolean check(TextEditable<?, ?> field, Function<String, String> translator) {
        field.error(null);
        if (field.value() == null || field.value().isEmpty()) {
            field.error(translator.apply("Field required"));
            return false;
        }
        return true;
    }

    public static boolean checkLanguageId(TextEditable<?, ?> field, Function<String, String> translator, EditorBox box) {
        if (!DisplayHelper.check(field, translator)) {
            return false;
        }
        if (!NameHelper.validName(field.value())) {
            field.error("Name contains non alphanumeric characters");
            return false;
        }
        if (NameHelper.reservedName(field.value())) {
            field.error("This name is reserved and cannot be used.");
            return false;
        }
        if (NameHelper.modelInUse(field.value(), box)) {
            field.error("Already exists a model with that name");
            return false;
        }
        return true;
    }

    public static boolean checkLanguageInUse(TextEditable<?, ?> field, Function<String, String> translator, EditorBox box) {
        if (NameHelper.languageInUse(field.value(), box)) {
            field.error("Already exists a language with that name");
            return false;
        }
        return true;
    }

    public static Resource emptyFile() {
        return new Resource("empty", (InputStream)new ByteArrayInputStream(new byte[0]));
    }

    public static UIFile uiFile(String label, File content) {
        try {
            if (!content.exists()) {
                return DisplayHelper.uiFile(label, new ByteArrayInputStream(new byte[0]));
            }
            return DisplayHelper.uiFile(label, new FileInputStream(content));
        }
        catch (FileNotFoundException e) {
            Logger.error((Throwable)e);
            return DisplayHelper.uiFile(label, new ByteArrayInputStream(new byte[0]));
        }
    }

    public static UIFile uiFile(final String label, final InputStream content) {
        return new UIFile(){

            public String label() {
                return label;
            }

            public InputStream content() {
                return content;
            }
        };
    }
}

