/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.AddCollectionItemEvent;
import io.intino.alexandria.ui.model.Datasource;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.datasources.LanguagesDatasource;
import io.quassar.editor.box.ui.displays.items.LanguageItem;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguagesTemplate;
import io.quassar.editor.box.ui.types.LanguagesTab;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.SessionHelper;
import io.quassar.editor.model.Language;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class LanguagesTemplate
extends AbstractLanguagesTemplate<EditorBox> {
    private LanguagesTab tab;
    private Consumer<Language> selectListener;
    private LanguagesDatasource source;

    public LanguagesTemplate(EditorBox box) {
        super(box);
    }

    public void open(String tab) {
        this.tab = tab != null ? LanguagesTab.from(tab) : SessionHelper.languagesTab(this.session());
        this.refresh();
    }

    public void filter(String condition) {
        this.languagesCatalog.filter(condition);
    }

    public void filter(String grouping, List<String> values) {
        this.languagesCatalog.filter(grouping, values);
    }

    public void onSelect(Consumer<Language> listener) {
        this.selectListener = listener;
    }

    public void source(LanguagesDatasource source) {
        this.source = source;
    }

    @Override
    public void init() {
        super.init();
        this.languagesCatalog.onAddItem(this::refresh);
        this.searchBox.onEnterPress(e -> this.filter((String)e.value()));
        this.searchBox.onChange(e -> this.filter((String)e.value()));
    }

    public void refresh() {
        super.refresh();
        this.searchBox.value(null);
        this.refreshLanguages();
    }

    private void refreshLanguages() {
        LanguagesDatasource source = this.source != null ? this.source : new LanguagesDatasource((EditorBox)this.box(), this.session());
        this.languagesCatalog.source((Datasource)source);
        this.searchBox.visible(source.itemCount(null, Collections.emptyList()) > DisplayHelper.MinItemsCount);
    }

    private void refresh(AddCollectionItemEvent event) {
        Language language = (Language)event.item();
        LanguageItem item = (LanguageItem)event.component();
        item.logo.value(LanguageHelper.logo(language, (EditorBox)this.box()));
        this.refreshName(language, item);
        this.refreshNameSelector(language, item);
        item.title.value(language.title());
        item.description.value(language.description());
    }

    private void refreshName(Language language, LanguageItem item) {
        item.name.visible(this.selectListener == null);
        if (!item.name.isVisible()) {
            return;
        }
        item.name.title(language.key().toLowerCase());
        item.name.address(path -> PathHelper.languagePath(path, language));
    }

    private void refreshNameSelector(Language language, LanguageItem item) {
        item.nameSelector.visible(this.selectListener != null);
        if (!item.nameSelector.isVisible()) {
            return;
        }
        item.nameSelector.title(language.key().toLowerCase());
        item.nameSelector.onExecute(e -> this.notifySelect(language));
    }

    private void notifySelect(Language language) {
        this.selectListener.accept(language);
    }
}

