/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageExplorer;
import io.quassar.editor.box.ui.displays.templates.ModelsTemplate;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import java.util.function.Consumer;

public class LanguageExplorer
extends AbstractLanguageExplorer<EditorBox> {
    private Language language;
    private LanguageTab tab;
    private String release;
    private boolean refreshRequired = false;
    private boolean expanded = true;
    private Consumer<Boolean> expandListener;
    private Consumer<Boolean> collapseListener;

    public LanguageExplorer(EditorBox box) {
        super(box);
    }

    public void invalidateCache(boolean value) {
        this.refreshRequired = value;
    }

    public void language(Language language) {
        this.refreshRequired = this.refreshRequired || this.language == null || !language.name().equals(this.language.name());
        this.language = language;
    }

    public void release(String release) {
        this.refreshRequired = this.refreshRequired || !release.equals(this.release);
        this.release = release;
    }

    public void tab(LanguageTab tab) {
        this.refreshRequired = this.refreshRequired || !tab.equals((Object)this.tab);
        this.tab = tab;
    }

    public void onExpand(Consumer<Boolean> listener) {
        this.expandListener = listener;
    }

    public void onCollapse(Consumer<Boolean> listener) {
        this.collapseListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.initToolbar();
        this.releaseSelector.onSelect(this::updateRelease);
        this.aboutBlock.onShow(e -> this.refreshAbout());
        this.versionsBlock.onShow(e -> this.refreshHelp());
        this.examplesBlock.onShow(e -> this.refreshExamples());
    }

    public void refresh() {
        super.refresh();
        if (!this.refreshRequired) {
            return;
        }
        this.refreshRequired = false;
        this.refreshSimpleTitle();
        this.refreshReleaseTitle();
        if (!this.expanded) {
            this.expand();
        } else {
            this.refreshBlocks();
        }
    }

    private void initToolbar() {
        this.expandExplorer.onExecute(e -> this.expand());
        this.expandExplorerFull.onExecute(e -> this.expand());
        this.collapseExplorer.onExecute(e -> this.collapse());
    }

    private void refreshSimpleTitle() {
        this.simpleTitle.visible(this.tab == LanguageTab.About);
        if (!this.simpleTitle.isVisible()) {
            return;
        }
        this.title.value(this.translate(LanguageHelper.title(this.tab)).formatted(this.language.key().toLowerCase(), this.release));
    }

    private void refreshReleaseTitle() {
        this.releaseTitle.visible(this.tab != LanguageTab.About);
        if (!this.releaseTitle.isVisible()) {
            return;
        }
        this.titlePrefix.value(this.translate(LanguageHelper.title(this.tab)).formatted(this.language.key().toLowerCase(), this.release));
        this.refreshReleaseSelector();
    }

    private void refreshReleaseSelector() {
        this.releaseSelector.visible(this.tab != LanguageTab.About);
        if (!this.releaseSelector.isVisible()) {
            return;
        }
        this.releaseSelector.clear();
        this.releaseSelector.addAll(this.language.releases().reversed().stream().map(LanguageRelease::version).toList());
        this.releaseSelector.selection(new String[]{this.release});
    }

    private void refreshBlocks() {
        this.collapsedBlock.visible(!this.expanded);
        this.refreshExpandedBlock();
    }

    private void refreshExpandedBlock() {
        this.expandedBlock.visible(this.expanded);
        if (!this.expandedBlock.isVisible()) {
            return;
        }
        this.aboutBlock.hide();
        this.versionsBlock.hide();
        this.examplesBlock.hide();
        if (this.tab == LanguageTab.Help) {
            this.versionsBlock.show();
        } else if (this.tab == LanguageTab.Examples) {
            this.examplesBlock.show();
        } else {
            this.aboutBlock.show();
        }
    }

    private void refreshAbout() {
        this.refreshMetamodel();
        this.refreshForge();
        this.aboutTitle.value(DisplayHelper.valueOrDefault(this.language.title()));
        this.aboutDescription.value(DisplayHelper.valueOrDefault(this.language.description()).replace("\n", "<br/>"));
        this.aboutCitation.value(DisplayHelper.valueOrDefault(this.language.citation()).replace("\n", "<br/>"));
        this.aboutCitationLink.visible(!this.language.citationLink().isEmpty());
        if (this.aboutCitationLink.isVisible()) {
            this.aboutCitationLink.text(this.language.citationLink());
        }
        this.aboutLicense.value(DisplayHelper.valueOrDefault(this.language.license()).replace("\n", "<br/>"));
    }

    private void refreshHelp() {
        String content = ((EditorBox)this.box()).languageManager().loadHelp(this.language, this.release);
        this.releaseHelpStamp.content("<div class='help'>" + (content != null ? content : "") + "</div>");
        this.releaseHelpStamp.refresh();
    }

    private void refreshMetamodel() {
        this.aboutBlock.aboutContent.metamodelBlock.visible(PermissionsHelper.canEdit(this.language, this.session(), (EditorBox)this.box()));
        if (!this.aboutBlock.aboutContent.metamodelBlock.isVisible()) {
            return;
        }
        this.metamodelLink.address(path -> PathHelper.modelPath(((EditorBox)this.box()).modelManager().get(this.language.metamodel())));
    }

    private void refreshForge() {
        String metamodel = this.language.metamodel();
        this.aboutBlock.aboutContent.forgeBlock.visible(metamodel != null && PermissionsHelper.canEdit(this.language, this.session(), (EditorBox)this.box()));
        if (!this.aboutBlock.aboutContent.forgeBlock.isVisible()) {
            return;
        }
        this.forgeLink.site(PathHelper.forgeUrl(((EditorBox)this.box()).modelManager().get(metamodel), this.release, this.session()));
    }

    private void refreshExamples() {
        this.examplesDialog.visible(this.tab == LanguageTab.Examples);
        this.examplesStamp.language(this.language);
        this.examplesStamp.release(this.language.release(this.release));
        this.examplesStamp.mode(ModelsTemplate.Mode.Embedded);
        this.examplesStamp.tab(LanguageTab.Examples);
        this.examplesStamp.bindTo(this.examplesDialog);
        this.examplesStamp.refresh();
    }

    private void updateRelease(SelectionEvent event) {
        if (event.selection().isEmpty()) {
            return;
        }
        String selected = (String)event.selection().getFirst();
        this.release(selected);
        this.refresh();
    }

    private void expand() {
        this.collapsedBlock.hide();
        this.expandListener.accept(true);
        this.expanded = true;
        this.refreshBlocks();
        this.expandedBlock.show();
    }

    private void collapse() {
        this.expandedBlock.hide();
        this.collapsedBlock.show();
        this.collapseListener.accept(true);
        this.expanded = false;
        this.refreshBlocks();
    }
}

