/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractCommitModelDialog;
import io.quassar.editor.box.ui.types.VersionType;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;
import io.quassar.editor.model.ModelRelease;
import java.util.List;
import java.util.function.BiConsumer;

public class CommitModelDialog
extends AbstractCommitModelDialog<EditorBox> {
    private Model model;
    private BiConsumer<Model, String> commitListener;
    private BiConsumer<Model, Command.CommandResult> commitFailureListener;
    private BiConsumer<Model, Command.CommandResult> createReleaseListener;
    private static final List<String> AllVersions = List.of("Replace existing", "Revision", "Minor version", "Major version");
    private static final List<String> Versions = List.of("Revision", "Minor version", "Major version");

    public CommitModelDialog(EditorBox box) {
        super(box);
    }

    public void model(Model value) {
        this.model = value;
    }

    public void onCommit(BiConsumer<Model, String> listener) {
        this.commitListener = listener;
    }

    public void onCommitFailure(BiConsumer<Model, Command.CommandResult> listener) {
        this.commitFailureListener = listener;
    }

    public void onCreateRelease(BiConsumer<Model, Command.CommandResult> listener) {
        this.createReleaseListener = listener;
    }

    public void open() {
        this.dialog.open();
    }

    @Override
    public void init() {
        super.init();
        this.dialog.onOpen(e -> this.refreshDialog());
        this.create.onExecute(e -> this.commit());
        this.versionTypeSelector.onSelect(this::updateVersion);
        this.versionTypeSelector.selection(this.translate("Revision"));
    }

    private void refreshDialog() {
        Language language = ((EditorBox)this.box()).languageManager().getWithMetamodel(this.model);
        boolean versionInUse = ((EditorBox)this.box()).modelManager().existsModelsWithReleasesFor(language, this.model.lastRelease());
        boolean hasVersions = this.model.lastRelease() != null;
        List<String> options = (versionInUse || !hasVersions ? Versions : AllVersions).stream().map(arg_0 -> ((CommitModelDialog)this).translate(arg_0)).toList();
        VersionType type = versionInUse || !hasVersions ? VersionType.Revision : VersionType.SnapshotVersion;
        this.dialog.title("Commit %s".formatted(ModelHelper.label(this.model, this.language(), (EditorBox)this.box())));
        this.refreshVersionBlock(type, options);
    }

    private void refreshVersionBlock(VersionType type, List<String> options) {
        this.versionPropertiesBlock.visible(true);
        if (!this.versionPropertiesBlock.isVisible()) {
            return;
        }
        String value = ModelHelper.nextVersion(this.model, type, (EditorBox)this.box());
        this.version.value(value);
        this.versionTypeSelector.clear();
        this.versionTypeSelector.addAll(options);
        this.versionTypeSelector.selection(type == VersionType.Revision ? this.translate("Revision") : this.translate("Replace existing"));
        this.versionTypeSelector.readonly(value.equals("1.0.0"));
        this.version.value(ModelHelper.nextVersion(this.model, type, (EditorBox)this.box()));
    }

    private void commit() {
        if (!this.check()) {
            return;
        }
        this.dialog.close();
        Command.CommandResult result = this.createRelease();
        if (!result.success()) {
            this.commitFailureListener.accept(this.model, result);
        } else {
            this.commitListener.accept(this.model, this.version());
        }
    }

    private Command.CommandResult createRelease() {
        this.notifyUser(this.translate("Committing..."), UserMessage.Type.Loading);
        Command.CommandResult result = ((EditorBox)this.box()).commands(ModelCommands.class).createRelease(this.model, this.version(), this.username());
        if (!result.success()) {
            this.hideUserNotification();
            this.commitFailureListener.accept(this.model, result);
        } else {
            this.createReleaseListener.accept(this.model, result);
            this.openFinishDialog();
        }
        return result;
    }

    private String version() {
        String result = this.version.value();
        return result != null && !result.isEmpty() ? result : ModelHelper.nextVersion(this.model, VersionType.Revision, (EditorBox)this.box());
    }

    private boolean check() {
        return true;
    }

    private void updateVersion(SelectionEvent event) {
        this.version.value(ModelHelper.nextVersion(this.model, this.versionType(event), (EditorBox)this.box()));
    }

    private VersionType versionType(SelectionEvent event) {
        String selected = (String)event.selection().getFirst();
        if (selected.equals(this.translate("Revision"))) {
            return VersionType.Revision;
        }
        if (selected.equals(this.translate("Minor version"))) {
            return VersionType.MinorVersion;
        }
        if (selected.equals(this.translate("Replace existing"))) {
            return VersionType.SnapshotVersion;
        }
        return VersionType.MajorVersion;
    }

    private void openFinishDialog() {
        this.hideUserNotification();
    }

    private void openExecutionDialog(ModelRelease release) {
        this.executionLauncher.model(this.model);
        this.executionLauncher.release(release.version());
        this.executionLauncher.launch();
    }

    private void openDownloadModel(ModelRelease release) {
        this.downloadModelDialog.title(this.translate("%s %s generated").formatted(ModelHelper.label(this.model, this.language(), (EditorBox)this.box()), release.version()));
        this.downloadModelDialog.model(this.model);
        this.downloadModelDialog.release(release.version());
        this.downloadModelDialog.open();
    }
}

