/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands.model;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.exceptions.NotFound;
import io.intino.alexandria.logger.Logger;
import io.intino.builderservice.schemas.Message;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.builder.BuildResult;
import io.quassar.editor.box.builder.ModelBuilder;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.model.CheckModelCommand;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.TarHelper;
import io.quassar.editor.box.util.WorkspaceHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import io.quassar.editor.model.OperationResult;
import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class CreateModelReleaseCommand
extends Command<Command.CommandResult> {
    public Model model;
    public String version;

    public CreateModelReleaseCommand(EditorBox box) {
        super(box);
    }

    @Override
    public Command.CommandResult execute() {
        Command.CommandResult result = this.check();
        if (!result.success()) {
            return result;
        }
        if (this.box.modelManager().release(this.model, this.version).exists()) {
            return this.resultOf(this.replaceRelease());
        }
        return this.resultOf(this.box.modelManager().createRelease(this.model, this.version));
    }

    private OperationResult replaceRelease() {
        this.removeTemporalWorkspace();
        OperationResult result = this.box.modelManager().replaceRelease(this.model, this.version);
        Language language = this.box.languageManager().getWithMetamodel(this.model);
        if (language == null) {
            return result;
        }
        LanguageRelease release = language.release(this.version);
        if (release == null) {
            return result;
        }
        BuildResult rebuildResult = this.rebuild(language, release);
        return !rebuildResult.success() ? OperationResult.Error(rebuildResult.messages().stream().map(Message::content).collect(Collectors.joining("; "))) : result;
    }

    private void removeTemporalWorkspace() {
        try {
            if ("draft".equals(this.version)) {
                return;
            }
            File file = WorkspaceHelper.releaseWorkSpace(this.model, this.version, this.box.archetype());
            if (file == null || !file.exists()) {
                return;
            }
            FileUtils.deleteDirectory((File)file);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    private Command.CommandResult check() {
        CheckModelCommand command = new CheckModelCommand(this.box);
        command.author = this.author;
        command.model = this.model;
        command.release = "draft";
        return command.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BuildResult rebuild(Language language, LanguageRelease release) {
        File destination = null;
        try {
            BuildResult result = new ModelBuilder(this.model, new GavCoordinates(language.group(), language.name(), release.version()), this.box).build(this.author);
            if (!result.success()) {
                BuildResult buildResult = result;
                return buildResult;
            }
            Resource resource = result.zipArtifacts();
            destination = this.box.archetype().tmp().builds(UUID.randomUUID().toString());
            TarHelper.extract(resource.inputStream(), destination);
            this.box.languageManager().saveDsl(language, release.version(), LanguageHelper.dslOf(destination));
            this.box.languageManager().saveDslManifest(language, release.version(), LanguageHelper.dslManifestOf(destination));
            this.box.languageManager().saveGraph(language, release.version(), LanguageHelper.graphOf(destination));
            this.box.languageManager().saveParsers(language, release.version(), LanguageHelper.parsersOf(destination));
            BuildResult buildResult = result;
            return buildResult;
        }
        catch (InternalServerError | NotFound | Exception e) {
            Logger.error((Throwable)e);
            BuildResult buildResult = BuildResult.failure(List.of(new Message().content(e.getMessage()).kind(Message.Kind.ERROR)));
            return buildResult;
        }
        finally {
            if (destination != null) {
                destination.delete();
            }
        }
    }
}

