/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.actions;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.EditorBox;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;

public class FilesCleanerAction {
    public EditorBox box;

    public void execute() {
        this.temporalDirectories().forEach(this::clean);
    }

    private List<File> temporalDirectories() {
        File[] files = this.box.archetype().tmp().root().listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).filter(File::isDirectory).toList();
    }

    private void clean(File root) {
        File[] files = root.listFiles();
        if (files == null) {
            return;
        }
        Arrays.stream(files).filter(this::isOld).forEach(this::delete);
        Logger.info((String)("Cleaned " + root.getAbsolutePath() + " files before " + String.valueOf(this.borderDay())));
    }

    private boolean isOld(File file) {
        try {
            FileTime creationTime = (FileTime)Files.getAttribute(file.toPath(), "creationTime", new LinkOption[0]);
            Timetag date = Timetag.of((Instant)creationTime.toInstant(), (Scale)Scale.Day);
            return date.isBefore(this.borderDay());
        }
        catch (IOException e) {
            return false;
        }
    }

    private Timetag borderDay() {
        DayOfWeek day = WeekFields.of(Locale.getDefault()).getFirstDayOfWeek();
        LocalDate date = LocalDate.now().with(TemporalAdjusters.previousOrSame(day)).minusDays(1L);
        return Timetag.of((LocalDate)date, (Scale)Scale.Day);
    }

    private void delete(File file) {
        try {
            if (file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
            } else {
                file.delete();
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }
}

