/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.util;

import io.intino.ls.document.DocumentManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarUtils {
    public static void decompressTarFile(byte[] tarFile, DocumentManager manager, String path, boolean replace) throws IOException {
        try (TarArchiveInputStream tarInput = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(tarFile));){
            TarArchiveEntry entry;
            while ((entry = tarInput.getNextTarEntry()) != null) {
                TarUtils.processEntry(manager, path, entry, tarInput, replace);
            }
        }
    }

    private static void processEntry(DocumentManager manager, String path, TarArchiveEntry entry, TarArchiveInputStream tarInput, boolean replace) throws IOException {
        File entryFile = new File(manager.root().getPath(), path + File.separator + entry.getName());
        if (entry.isDirectory()) {
            if (!entryFile.exists()) {
                entryFile.mkdirs();
            }
        } else {
            if (entryFile.exists() && !replace) {
                return;
            }
            File parent = entryFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            try (FileOutputStream out = new FileOutputStream(entryFile);){
                TarUtils.copyStream((InputStream)tarInput, out);
            }
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) > 0) {
            out.write(buffer, 0, length);
        }
    }

    public static File createTarFile(DocumentManager manager, List<URI> uris, File outputTarFile) throws IOException {
        try (TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)new FileOutputStream(outputTarFile));){
            for (URI uri : uris) {
                TarUtils.tarFile(tarOut, manager.getDocumentText(uri), uri.getPath());
            }
            File file = outputTarFile;
            return file;
        }
    }

    private static void tarFile(TarArchiveOutputStream tarOut, InputStream is, String entryName) throws IOException {
        byte[] bytes = is.readAllBytes();
        TarArchiveEntry entry = new TarArchiveEntry(entryName);
        entry.setSize((long)bytes.length);
        tarOut.putArchiveEntry((ArchiveEntry)entry);
        tarOut.write(bytes);
        tarOut.closeArchiveEntry();
    }

    private static void tarDirectory(TarArchiveOutputStream tarOut, File file, String entryName) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(file, entryName + File.separator);
        tarOut.putArchiveEntry((ArchiveEntry)entry);
        tarOut.closeArchiveEntry();
        for (File child : file.listFiles()) {
            String entryName1 = entryName + File.separator + child.getName();
            if (child.isDirectory()) {
                TarUtils.tarDirectory(tarOut, child, entryName1);
                continue;
            }
            TarUtils.tarFile(tarOut, null, entryName1);
        }
    }
}

