/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class TarHelper {
    public static void extract(InputStream stream, File destination) throws IOException {
        if (!destination.exists()) {
            destination.mkdirs();
        }
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream(stream);){
            TarArchiveEntry entry;
            while ((entry = tarIn.getNextTarEntry()) != null) {
                File outputFile = new File(destination, entry.getName());
                if (entry.isDirectory()) {
                    outputFile.mkdirs();
                    continue;
                }
                outputFile.getParentFile().mkdirs();
                try (FileOutputStream out = new FileOutputStream(outputFile);){
                    int len;
                    byte[] buffer = new byte[4096];
                    while ((len = tarIn.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                }
            }
        }
    }
}

