/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.util;

import io.quassar.editor.box.models.File;
import io.quassar.editor.box.schemas.IntinoFileBrowserItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IntinoFileBrowserHelper {
    public static List<IntinoFileBrowserItem> fileBrowserItems(List<File> files) {
        HashMap items = new HashMap();
        files.forEach(f -> IntinoFileBrowserHelper.register(f, items));
        return new ArrayList<IntinoFileBrowserItem>(items.values());
    }

    public static IntinoFileBrowserItem itemOf(File file) {
        IntinoFileBrowserItem.Type type = file.isDirectory() ? IntinoFileBrowserItem.Type.Folder : IntinoFileBrowserItem.Type.File;
        return IntinoFileBrowserHelper.itemOf(file.uri(), file.parents(), type, file.parents().isEmpty());
    }

    private static void register(File file, Map<String, IntinoFileBrowserItem> items) {
        List<String> parents = file.parents();
        if (!items.containsKey(file.uri())) {
            items.put(file.uri(), IntinoFileBrowserHelper.itemOf(file).id(items.size()));
        }
        for (int i = 0; i < parents.size(); ++i) {
            IntinoFileBrowserHelper.register(IntinoFileBrowserHelper.uri(parents, i), i > 0 ? IntinoFileBrowserHelper.uri(parents, i - 1) : null, items);
            if (i != parents.size() - 1) continue;
            IntinoFileBrowserHelper.register(file, IntinoFileBrowserHelper.uri(parents, i), i == 0, items);
        }
    }

    private static void register(String directory, String parent, Map<String, IntinoFileBrowserItem> items) {
        if (!items.containsKey(directory)) {
            items.put(directory, IntinoFileBrowserHelper.itemOf(directory, parent != null ? List.of(parent) : Collections.emptyList(), IntinoFileBrowserItem.Type.Folder, parent == null).id(items.size()));
        }
        if (parent != null && !items.get(parent).children().contains(directory)) {
            items.get(parent).children().add(directory);
        }
    }

    private static void register(File file, String parent, boolean isRoot, Map<String, IntinoFileBrowserItem> items) {
        if (!items.containsKey(parent)) {
            items.put(parent, IntinoFileBrowserHelper.itemOf(parent, Collections.emptyList(), IntinoFileBrowserItem.Type.Folder, isRoot).id(items.size()));
        }
        if (file != null && !items.get(parent).children().contains(file.uri())) {
            items.get(parent).children().add(file.uri());
        }
    }

    private static String uri(List<String> parents, int i) {
        return String.join((CharSequence)"/", parents.subList(0, i + 1));
    }

    private static IntinoFileBrowserItem itemOf(String uri, List<String> parents, IntinoFileBrowserItem.Type type, boolean isRoot) {
        return new IntinoFileBrowserItem().name(IntinoFileBrowserHelper.nameOf(uri)).uri(uri).parents(parents).type(type).isRoot(isRoot);
    }

    private static String nameOf(String uri) {
        return uri.contains("/") ? uri.substring(uri.lastIndexOf("/") + 1) : uri;
    }
}

