/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageTemplate;
import io.quassar.editor.box.ui.displays.templates.LanguageReleaseHelp;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.ui.types.LanguageView;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.box.util.SessionHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.util.List;

public class LanguageTemplate
extends AbstractLanguageTemplate<EditorBox> {
    private Language language;
    private LanguageRelease release;
    private LanguageTab tab;
    private LanguageView view;

    public LanguageTemplate(EditorBox box) {
        super(box);
    }

    public void open(String language, String tab, String view) {
        this.language = ((EditorBox)this.box()).languageManager().get(language);
        this.release = null;
        this.tab = tab != null ? LanguageTab.from(tab) : SessionHelper.languageTab(this.session());
        this.view = view != null ? LanguageView.from(view) : SessionHelper.languageView(this.session());
        this.refresh();
    }

    public void openHelp(String language, String version) {
        this.language = ((EditorBox)this.box()).languageManager().get(language);
        this.release = this.language.release(version);
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.helpBlock.onShow(e -> this.refreshHelpBlock());
        this.mainBlock.onInit(e -> this.initMainBlock());
        this.mainBlock.onShow(e -> this.refreshMainBlock());
    }

    public void refresh() {
        super.refresh();
        this.notFoundBlock.visible(!PermissionsHelper.hasPermissions(this.language, this.session(), (EditorBox)this.box()));
        this.refreshHeader();
        this.refreshBlocks();
    }

    private void refreshBlocks() {
        if (!PermissionsHelper.hasPermissions(this.language, this.session(), (EditorBox)this.box())) {
            this.mainBlock.hide();
            this.helpBlock.hide();
            return;
        }
        if (this.release != null) {
            this.mainBlock.hide();
            this.helpBlock.show();
        } else {
            this.helpBlock.hide();
            this.mainBlock.show();
        }
    }

    private void refreshHelpBlock() {
        this.helpTitle.value(this.translate(this.title(LanguageView.Help)).formatted(LanguageHelper.title(GavCoordinates.fromString(this.language, this.release))));
        this.helpLogo.value(LanguageHelper.logo(this.language, (EditorBox)this.box()));
        String content = ((EditorBox)this.box()).languageManager().loadHelp(this.language, this.release);
        this.helpStamp.content(content);
        this.helpStamp.refresh();
    }

    private void initMainBlock() {
        this.mainBlock.mainContentBlock.homeBlock.onShow(e -> this.refreshHome());
        this.mainBlock.mainContentBlock.modelsBlock.onShow(e -> this.refreshModels());
    }

    private void refreshMainBlock() {
        this.mainBlock.mainContentBlock.modelsBlock.modelsStamp.onCreateModel(this.tab != LanguageTab.Examples ? e -> this.createModel() : null);
        this.refreshHome();
        this.refreshModels();
    }

    private void refreshHeader() {
        this.headerStamp.visible(this.release == null && PermissionsHelper.hasPermissions(this.language, this.session(), (EditorBox)this.box()));
        if (!this.headerStamp.isVisible()) {
            return;
        }
        this.headerStamp.language(this.language);
        this.headerStamp.tab(this.tab);
        this.headerStamp.view(this.view);
        this.headerStamp.refresh();
    }

    private void refreshHome() {
        this.title.value(this.translate(this.title()).formatted(this.language.key().toLowerCase()));
        this.logo.value(LanguageHelper.logo(this.language, (EditorBox)this.box()));
        this.refreshHelpVersions();
        this.refreshAbout();
    }

    private String title() {
        return this.title(this.view);
    }

    private String title(LanguageView view) {
        if (view == LanguageView.Help) {
            return "%s help";
        }
        return "about %s";
    }

    private void refreshHelpVersions() {
        this.mainBlock.mainContentBlock.homeBlock.viewsBlock.versionsBlock.visible(this.view == LanguageView.Help);
        if (!this.mainBlock.mainContentBlock.homeBlock.viewsBlock.versionsBlock.isVisible()) {
            return;
        }
        List<LanguageRelease> releases = this.language.releases();
        this.helps.clear();
        releases.forEach(r -> this.fill((LanguageRelease)r, (LanguageReleaseHelp)this.helps.add()));
    }

    private void refreshAbout() {
        this.mainBlock.mainContentBlock.homeBlock.viewsBlock.aboutBlock.visible(this.view == null || this.view == LanguageView.About);
        if (!this.mainBlock.mainContentBlock.homeBlock.viewsBlock.aboutBlock.isVisible()) {
            return;
        }
        this.aboutTitle.value(this.language.title());
        this.aboutDescription.value(DisplayHelper.valueOrDefault(this.language.description()).replace("\n", "<br/>"));
        this.aboutCitation.value(DisplayHelper.valueOrDefault(this.language.citation()).replace("\n", "<br/>"));
        this.aboutCitationLink.visible(!this.language.citationLink().isEmpty());
        if (this.aboutCitationLink.isVisible()) {
            this.aboutCitationLink.text(this.language.citationLink());
        }
        this.aboutLicense.value(DisplayHelper.valueOrDefault(this.language.license()).replace("\n", "<br/>"));
    }

    private void fill(LanguageRelease release, LanguageReleaseHelp display) {
        display.language(this.language);
        display.release(release);
        display.refresh();
    }

    private void refreshModels() {
        this.mainBlock.mainContentBlock.modelsBlock.modelsStamp.language(this.language);
        this.mainBlock.mainContentBlock.modelsBlock.modelsStamp.tab(this.tab);
        this.mainBlock.mainContentBlock.modelsBlock.modelsStamp.refresh();
    }

    private Model createModel() {
        LanguageRelease release = this.language.lastRelease();
        String name = ModelHelper.proposeName();
        return ((EditorBox)this.box()).commands(ModelCommands.class).create(name, name, "", GavCoordinates.fromString(this.language, release), DisplayHelper.user(this.session()), this.username());
    }
}

