/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.LanguageCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguagePropertiesTemplate;
import io.quassar.editor.box.ui.displays.templates.TagEditor;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageProperty;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class LanguagePropertiesTemplate
extends AbstractLanguagePropertiesTemplate<EditorBox> {
    private Language language;
    private String release;
    private Set<String> tagSet;

    public LanguagePropertiesTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void release(String release) {
        this.release = release;
    }

    @Override
    public void init() {
        super.init();
        this.titleField.onChange(e -> this.save(LanguageProperty.Title, this.titleField.value()));
        this.descriptionField.onChange(e -> this.save(LanguageProperty.Description, this.descriptionField.value()));
        this.citationField.onChange(e -> this.save(LanguageProperty.Citation, this.citationField.value()));
        this.citationLinkField.onChange(e -> this.save(LanguageProperty.CitationLink, this.citationLinkField.value()));
        this.licenseField.onChange(e -> this.save(LanguageProperty.License, this.licenseField.value()));
        this.addTagDialog.onOpen(e -> this.refreshTagDialog());
        this.addTag.onExecute(e -> this.addTag());
        this.tagField.onEnterPress(e -> this.addTag());
    }

    public void refresh() {
        super.refresh();
        this.tagSet = new HashSet<String>(this.language.tags());
        this.titleField.value(this.language.title());
        this.descriptionField.value(this.language.description());
        this.licenseField.value(this.language.license());
        this.citationField.value(this.language.citation());
        this.citationLinkField.value(this.language.citationLink());
        this.refreshTags();
    }

    private void refreshTagDialog() {
        this.tagField.value(null);
    }

    private void refreshTags() {
        this.tags.clear();
        this.tagSet.stream().sorted(Comparator.naturalOrder()).forEach(o -> this.fill((String)o, (TagEditor)this.tags.add()));
    }

    private void fill(String tag, TagEditor display) {
        display.tag(tag);
        display.onRemove(o -> this.removeTag(tag));
        display.refresh();
    }

    private void removeTag(String tag) {
        this.tagSet.remove(tag);
        this.save(LanguageProperty.Tags, new ArrayList<String>(this.tagSet));
        this.refreshTags();
    }

    private void addTag() {
        if (!DisplayHelper.check(this.tagField, arg_0 -> ((LanguagePropertiesTemplate)this).translate(arg_0))) {
            return;
        }
        this.addTagDialog.close();
        this.tagSet.add(this.tagField.value());
        this.save(LanguageProperty.Tags, new ArrayList<String>(this.tagSet));
        this.refreshTags();
    }

    private void save(LanguageProperty property, Object value) {
        ((EditorBox)this.box()).commands(LanguageCommands.class).save(this.language, property, value, this.username());
    }
}

