/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractDependencyTemplate;
import io.quassar.editor.box.util.ArtifactoryHelper;
import io.quassar.editor.model.Language;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class DependencyTemplate
extends AbstractDependencyTemplate<EditorBox> {
    private Language language;
    private String release;
    private File file;

    public DependencyTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void release(String release) {
        this.release = release;
    }

    public void file(File file) {
        this.file = file;
    }

    public void refresh() {
        super.refresh();
        String extension = FilenameUtils.getExtension((String)this.file.getName());
        this.title.value(this.translate("Reader for %s").formatted(this.file.getName().replace("." + extension, "")));
        this.contentField.value("<pre style='margin:0'>" + this.dependency().replace("<", "&lt;").replace("\t", "<span style='margin-right:10px'>&nbsp;</span>") + "</pre>");
        this.contentLink.text(this.dependency());
        this.repositoryField.value("<pre style='margin:0'>" + this.repository().replace("<", "&lt;").replace("\t", "<span style='margin-right:10px'>&nbsp;</span>") + "</pre>");
        this.repositoryLink.text(this.repository());
    }

    private String dependency() {
        return ArtifactoryHelper.dependency(this.language, this.release, this.file);
    }

    private String repository() {
        return ArtifactoryHelper.repository(((EditorBox)this.box()).configuration().url());
    }
}

